 /*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2006-09-11 v8.0480 SUPPORT_ORIGIN75_FILTER								*
 * Hong 11/20/06 FIX_IGNORE_INVALID_CHARACTER									*
 * Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER							*
 * Hong 03/21/07 SUPPORT_FULL_PATH_FOR_LOAD_FILTER								*
 * Sim 03-24-2007 FIX_CUSTOM_BUTTON												*
 * Hong 03/29/07 v8.0592 FIX_FAIL_DRAG_AND_DROP_TO_GRAPH						*
 * Hong 03/29/07 v8.0592 CLEAN_UP_PLOT_ONLY_SUPPORT_XY							*
 * Sim 04-10-2007 FIX_GET_FILTER_FROM_SHEET_STORAGE								*
 * Hong 04/11/07 DRAG_AND_DROP_TO_GRAPH_NO_NEED_CARE_SPACE_OPTION				*
 * Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED								*
 * EJP 2007-05-14 v8.0618 QA70-9634 ADD_FILTERS_WITH_OPTION_TO_FILE_OPEN_DLG	*
 * Sim 05-25-2007 FIX_D&D_MULTI_ASC_FILE_IMPORT_MODE							*
 * Sim 05-30-2007 PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC					*
 * Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES						*
 * Sim 06-06-2007 IMPORT_MODE_IS_CHANGED_TO_1ST_IMPORT_MODE						*
 * Sim 07-17-2007 FILTER_MANAGER_TOOLS											*
 *	Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	*
 *	Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY								*
 *	Hong 01/16/08 v8.0786c FIX_STATIC_OBJ_NOT_CORRECT_RESET_WHEN_DEAL_WITH_EXCEL*
 *	Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
 *	Sim 10-23-2008 QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER*
 *	Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING	*
 *	Kyle 10/29/08 MOVE_CODE_FOR_DRAG_AND_DROP_TO_FILE_DRAG_N_DROP				*
 *	Sim 12-15-2008 QA80-12487-P1 FIX_OLD_FILTER_MISS_NEWEST_THEME_SETTING		*
 *	Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT*
 *	Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE				*
 *	Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC				*
 *	Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
 *	Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
 *	Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT		*
 *	Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY	*
 *	Folger 10/19/09 QA80-14459 BATCH_PROCESS_OPEN_OGW_HIDDENLY					*
 *	Kenny 11/10/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES		*
 *	Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
 *	Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81		*
 *	Hong 08/25/10 FIX_RUNTIME_ERROR_DRAG_AND_DROP_TO_GRAPH						*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
//#include <..\originlab\XFunctionEx.h>
#include <xfutils.h>
//#include <oFilterUtils.h> ///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
//#include <..\originlab\local.h> ///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
#include <GetNBox.h>
#include "Theme_utils.h" ///---Sim 10-23-2008 QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER
//#include <Array.h>
//#include <Dialog.h>
#include "ODlg8.h"

#include <oFilterUtils.h>// Hong 8/21/06 CLEAN_HEADER_FILE
////////////////////////////////////////////////////////////////////////////////////
#include "FileImportFirst.h" ///---Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
#include "IWBase.h"
#include "fu_utils.h" ///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
#include "import_utils.h" /// Hong 11/17/06 FIX_D&D_FAIL_COMPILE
//#include "iw_filter.h"
//#include "ImportWizard.h" ///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
//#include "IWfirst.h" ///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
#include "AscImpOptions.h" ///---Sim 10-23-2008 QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER

#include "dragNdrop.h"		///Kyle 10/29/08 MOVE_CODE_FOR_DRAG_AND_DROP_TO_FILE_DRAG_N_DROP

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
typedef bool (*FUNC_IW_GET_FILTER) (LPCSTR lpcszDataFile, string &strFilterFile, TreeNode &trFilter);

static IWBase s_iwFilter;

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
enum {
	FILTER_DDGRAPH_OPENONLY = 0,
	FILTER_DDGRAPH_PLOT,
	FILTER_DDGRAPH_PLOTSETTINGS
};
#define IS_FILTER_DDGRAPH(i) (FILTER_DDGRAPH_OPENONLY <= (i) && (i) <= FILTER_DDGRAPH_PLOTSETTINGS)

enum {
	FILTER_DDWORKSPACE_OPENONLY = 0,
	FILTER_DDWORKSPACE_PLOT_1LAYER,
	FILTER_DDWORKSPACE_PLOT_MULTILAYER,
	FILTER_DDWORKSPACE_PLOT_MULTIWINDOW
};
#define IS_FILTER_DDWORKSPACE(i) (FILTER_DDWORKSPACE_OPENONLY <= (i) && (i) <= FILTER_DDWORKSPACE_PLOT_MULTIWINDOW)

#define	IMPORT_FILTER_EXTENSION_WILD			"*.oif"
#define	FILTERS_FOLDER_NAME						"Filters\\"
*/
///---END REMOVE_TO_FU_UTILS

//#define IFF_TARGET_PAGE_TYPE	0x0001 ///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
///---Sim 08-02-2006 COMMON_DEFINED
/*
#define fuGetType(_tn)		fuGetInt(&_tn, IDE_FLT_TYPE, FILTER_TYPE_UNKNOWN)

#define fuIsRenameWks(_tn)							fuGetInt(&_tn, IDE_FLT_REN_WKS, FALSE)
#define fuIsRenameWorkbook(_tn)						fuGetFlag(&_tn, AI_FLAG_FNAME_TO_WKBK_NAME, FALSE)

#define fuGetOriginVersion(_tn)		fuGetDouble(&_tn, IDE_FLT_ORIGIN_VER, 7.5)

#define fuGetImportMode(_tn)			fuGetInt(&_tn, IDE_FLT_IMPORT_MODE, ASCIMP_MODE_REPLACE_DATA)

#define fuGetPlotID(_tn)					fuGetInt(&_tn, IDE_FLT_PLOT_TYPE, IDM_PLOT_LINE)
*/
///---END COMMON_DEFINED
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
///Hong 8/07/06 MOVE_TO_IMPWIZ_H
/*
/// AW 08/03/06 MORE_ON_IW_IMPORT
#define fuIsAppendFileNameToWorkBookComments(_tn)	fuGetFlag(&_tn, AI_FLAG_FNAME_TO_WKBK_COMMENTS, FALSE)
#define fuIsAppendFileNameWithoutPath(_tn)			fuGetFlag(&_tn, AI_FLAG_REMOVE_FNAME_PATH, FALSE)

/// AW 08/06/06 CHECK_IW_FILTER
static BOOL fuGetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bGetCommonNode = FALSE)
{
	//_MSG_INT(fuGetASCIMP, ascimp.iDelimited)
	
	TreeNode trASCIMP = trFilter.GetNode("ASCIMP");
	if( trASCIMP )
	{
		ascimp = trASCIMP;
		if( bGetCommonNode )
		{
			ascimp.iMode = trFilter.Common.ImportMode.nVal;
			ascimp.iRenameWks = trFilter.Common.RenameWks.nVal;
			ascimp.iPartial = trFilter.Common.Partial.nVal;
			ascimp.iPartialC1 = trFilter.Common.PartialC1.nVal;
			ascimp.iPartialC2 = trFilter.Common.PartialC2.nVal;
			ascimp.iPartialR1 = trFilter.Common.PartialR1.nVal;
			ascimp.iPartialR2 = trFilter.Common.PartialR2.nVal;
			ascimp.iSkipRows = tree_node_get_int(trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
			/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
			#if _OC_VER >= 0x0800
			ascimp.flags = tree_node_get_int(trFilter.Common.Flags, 0);
			#endif // _OC_VER >= 0x0800
			/// end SUPPORT_WORKBOOK_IMPWIZ
		}
		return TRUE;
	}
	return FALSE;
}
static BOOL fuGetCustomDate(TreeNode& tnFilter, string& strFormat)
{
	ASCIMP ai;
	if( fuGetASCIMP(tnFilter, ai) )
	{
		strFormat = ai.szDateFormat;
		strFormat.TrimLeft();
		strFormat.TrimRight();
		return (!strFormat.IsEmpty());
	}
	return FALSE;
}
/// END CHECK_IW_FILTER

static BOOL fuGetVarsRoot(TreeNode& tnFilter, TreeNode& tnVarsRoot)
{
	if( !tnFilter )
		return FALSE;
	if( !tnFilter.Variables )
		tnFilter.AddNode("Variables");
	tnVarsRoot = tnFilter.Variables;
	return TRUE;
}

static BOOL fuIsVarInPageInfo(TreeNode& tnFilter)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	if( !tnVars || !tnVars.PageInfo )
		return FALSE;
	return tnVars.PageInfo.nVal;
}

static int HeaderVariablesToPageInfo(Page &pgTarget, StringArray& saVarNames, StringArray& saVarValues)
{
	if( !pgTarget )
		return 1;
	
	pgTarget.Info.Add("User");
	pgTarget.Info.User.AddSection("Variables");
	
	string str;
	
	using var = pgTarget.Info.User.Variables;    
	for( int n = 0; n < saVarNames.GetSize(); n++ )
		var.AddString(saVarNames[n], saVarValues[n]);

	return 0;
}
/// END MORE_ON_IW_IMPORT

static bool fuGetPostImportScript(TreeNode &trFilter, string &strScript)
{
	if( !trFilter.Common.PostImportScript )
		return false;
	strScript = trFilter.Common.PostImportScript.strVal;
	
	/// EJP 12-20-2004 v8.0177 UTIL_FUNC_CONV_CR_TO_CRLF
	///	// The string went into the filter with CR-LF combo, but the tree or XML
	///	// code strips the CR char.  Here I will replace all LF chars with CR-LF combo.
	///	// First check if combo is there in case tree or XML behavior changes.
	///	if( -1 == strScript.Find("\r\n") ) // If CR-LF combo is not found
	///		strScript.Replace("\n", "\r\n"); // Replace LF with CR-LF
	check_convert_CR_str_to_CRLF(strScript);
	/// end UTIL_FUNC_CONV_CR_TO_CRLF
	
	return true;
}

///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
string fuGetDesignations(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColDesignations )
		str = trFilter.Common.ColDesignations.strVal;
	return str;
}
string fuGetFormats(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColFormats )
		str = trFilter.Common.ColFormats.strVal;
	return str;
}
BOOL fuGetRepetitive(TreeNode& trFilter)
{
	if( trFilter.Common.ColDesignationsRepetitive )
		return trFilter.Common.ColDesignationsRepetitive.nVal;
	return FALSE; // default is off
}
// Get the worksheet columns' formats or designations setting, it actually modifies the current settings according filter setting
// This function is called when need to change part of the current settings according filter.
static int GetColumnSetting(string &strSetting, LPCSTR lpcszFilterSetting, int nTargetCol, int nNumCols, BOOL bRepetitive)
{
	if( strSetting.IsEmpty() )
		return 1; // Error

	// If the filter is NULL, just use strSetting
	if( !lpcszFilterSetting )
		return 0; // Success
	
	int nFilterLen = lstrlen(lpcszFilterSetting);
	int nSettingLen = strSetting.GetLength();
	
	if( nSettingLen - nTargetCol < nFilterLen )
		return 1;
	
	int nPos = 0;
	int nCurPosInFilterStr = 0;
	
	LPSTR lpszSetting = strSetting.GetBuffer(nSettingLen);
	LPSTR lpsz = lpszSetting + nTargetCol;
	
	while( nPos < nNumCols )
	{
		if( nCurPosInFilterStr >= nFilterLen )
			nCurPosInFilterStr = bRepetitive ? 0 : nFilterLen - 1;

		*(lpsz + nPos) = *(lpcszFilterSetting + nCurPosInFilterStr);
		
		nPos++;
		nCurPosInFilterStr++;
	}
	strSetting.ReleaseBuffer();
	
	return 0;
}

///---END COMMON_FUNC_ON_BASE_CLASS
*/
/// end MOVE_TO_IMPWIZ_H

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
static bool _fuLoadFilter(TreeNode &tnFilter, LPCSTR lpcszFile)
{
	Tree trFilter;
	if( !trFilter.Load(lpcszFile) )
		return false; // failed to load filter file

	double dOrgVer = fuGetOriginVersion(trFilter);
	if( dOrgVer < 8.0 )
	{
		TreeNode tnHdrParams;// = fuGetHeaderParams(tnFilter);
		if( !tnFilter.Common.HeaderParameters )
			tnFilter.Common.AddNode("HeaderParameters");
		tnHdrParams = tnFilter.Common.HeaderParameters;
		
		if( tnHdrParams &&
			tnHdrParams.FirstLine && tnHdrParams.LastLine && tnHdrParams.Separator )
		{
			//fuSetExtractVarByScanning(trFilter, TRUE);
			TreeNode tn = trFilter;
			if ( !tn )
			{
				if ( !tn.Variables )
					tn.AddNode("Variables");
				tn.Variables.ExtractByScanning.nVal = TRUE;
			}
		}
	}
	
	//fuSetOriginVersion(trFilter);
	double dVer;
	LT_get_var("@V", &dVer);
	fuSetDouble(&trFilter, IDE_FLT_ORIGIN_VER, dVer);
	
	tnFilter = trFilter;
	return true;
}

static bool fuLoad(TreeNode &tnFilter, LPCSTR lpcszFile)
{
	// Check arguments
	if( !tnFilter || NULL == lpcszFile || 0 == *lpcszFile )
		return false;

	// Check for a file extension
	string strName = GetFileName(lpcszFile);
	if( -1 == strName.Find('.') )
		strName += ".oif";

	// If a path is specified then use it
	string strPath = GetFilePath(lpcszFile);
	if( !strPath.IsEmpty() )
	{
		strPath += strName;
		return _fuLoadFilter(tnFilter, strPath);
	}

	// Check 'Filters' folder
	strName.Insert(0, FILTERS_FOLDER_NAME);

	// Check user path
	strPath = GetAppPath(FALSE) + strName;
	if( _fuLoadFilter(tnFilter, strPath) )
		return true;
	
	// Check system path
	strPath = GetAppPath(TRUE) + strName;
	return _fuLoadFilter(tnFilter, strPath);
}

static bool fuGetTypeName(TreeNode &trFilter, string &strType)
{
	StringArray	saFilterTypeName ={"ASCII","Binary", "User Defined","ImportFilter_XF", "unknown"};
	
	int iType = fuGetType(trFilter);
	if( IS_FILTER_TYPE(iType) )
	{
		if ( iType < FILTER_TYPE_ASCII || iType > FILTER_TYPE_XFUNC )
			iType = FILTER_TYPE_UNKNOWN;
		strType = saFilterTypeName[iType];
		return true;
	}
	return false;
}

static int ImportErrorMsgBox(int iErr, LPCSTR lpcszFilter)
{
	string str, strErr;
	bool bAppendFilterName = false;

	switch( iErr )
	{
	case IMPERR_NO_FILTER:
		strErr = _L("No filter specified.");
		break;
	case IMPERR_LOAD_FILTER:
		str = _L("Error loading import filter:\n%s");
		strErr.Format(str, lpcszFilter);
		break;
	case IMPERR_NO_TARGET_PAGE:
		strErr = _L("No target page for data.");
		bAppendFilterName = true;
		break;
	case IMPERR_GET_IMPORT_FUNC:
		string strFilterType;
		Tree trFilter;
		/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
		///if( lpcszFilter && trFilter.Load(lpcszFilter) )
		if( lpcszFilter && fuLoad(trFilter, lpcszFilter) )
		/// end SUPPORT_VERSION_CHANGES
		{
			fuGetTypeName(trFilter, strFilterType);
			strErr.Format(_L("Failed to get pointer to %s import function."), strFilterType);
		}
		else
			strErr = _L("Failed to get pointer to import function.");
		break;
	case IMPERR_IMPORT_FUNC_ERR:
		string strFilterType;
		Tree trFilter;
		/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
		///if( lpcszFilter && trFilter.Load(lpcszFilter) )
		if( lpcszFilter && fuLoad(trFilter, lpcszFilter) )
		/// end SUPPORT_VERSION_CHANGES
		{
			fuGetTypeName(trFilter, strFilterType);
			strErr.Format(_L("%s import function returned error."), strFilterType);
		}
		else
			strErr = _L("The import function returned error.");
		bAppendFilterName = true;
		break;
	case IMPERR_PREPARE_WKS:
		strErr = _L("Error preparing worksheet for import.");
		bAppendFilterName = true;
		break;
	///---Sim 07-31-2006 ERR_HANDLE
	case IMPERR_IMPORT_MODE:
		strErr = _L("Error mode of import.");
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	case IMPERR_FILTER_TYPE:
		strErr = _L("Unknown filter type.");
		bAppendFilterName = true;
		break;
	///---Sim 07-31-2006 ERR_HANDLE
	case IMPERR_IWCLASS_UNDEFINED:
		strErr.Format(_L("Import wizard class %s undefined."), lpcszFilter);
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	///---Sim 07-31-2006 ERR_HANDLE
	case IMP_USER_CANCEL:
		strErr = _L("User cancel for import.");
		bAppendFilterName = true;
		break;
	///---END ERR_HANDLE
	case IMPERR_NONE:
	case IMPERR_CANCEL_ON_LOCKED_COL:
		return 0; // no error to report
	default:
		strErr = _L("Unknown error.");
		bAppendFilterName = true;
		break;
	}

	string strMsg;
	if( bAppendFilterName && lpcszFilter )
		strMsg.Format(_L("%s\n\nUsing filter:\n%s"), strErr, lpcszFilter);
	else
		strMsg = strErr;

	/// EJP 2006-07-10 v8.0445 DO_NOT_HALT_EXECUTION_ON_ERR
	///MessageBox(GetWindow(), strMsg, _L("File Import Error"));
	printf("File Import Error: %s\n", strMsg);
	/// end DO_NOT_HALT_EXECUTION_ON_ERR

	return 0;
}

static int _is_sheet_empty(Layer &ly)
{
	Page pg;
	ly.GetParent(pg);
	if( !pg )
		return false;
	int nPageType = pg.GetType();
	switch( nPageType )
	{
	case EXIST_WKS:
		Worksheet wks = ly;//pg.Layers();
		if( !wks )
			return -1;
		//----CPY 4/5/06 WKS_CAN_BE_CREATED_WITH_NO_COLS
		if(wks.GetNumCols() == 0)
			return 1;
		//----
		int nR1, nR2;
		if( !wks.GetBounds(nR1, 0, nR2, -1) )
			return -1;
		if( 0 == nR1 && -1 == nR2 )
			return 1;
		return 0;
		
	case EXIST_MATRIX:
		MatrixLayer ml = ly;//pg.Layers();
		if( !ml )
			return -1;
		if( ml.HasData() || ml.HasImage() )
			return 0;
		return 1;
	}
	return -1;
}
*/
///---END REMOVE_TO_FU_UTILS


/// AW 07/31/06 MORE_ON_IW_FILTER
/*
#define GRAPH_ADD_PLOT(_Type_, _GraphLayer_) \
		_Type_ _ly = pageData.Layers(); \
		_GraphLayer_.AddPlot(_ly, iPlotID); \
		break;
static int GraphData(GraphPage &grpgTarget, int iLayer, int iPlotID, Page &pageData)
{
	GraphLayer grLayer = grpgTarget.Layers(iLayer);

	switch( pageData.GetType() )
	{
	case EXIST_WKS:
		GRAPH_ADD_PLOT(Worksheet, grLayer)
	case EXIST_MATRIX:
		/// EJP 03-07-2003: Currently we can not get Matrix.  CP will fix.
		//GRAPH_ADD_PLOT(Matrix, grLayer)
		break;
	default:
		return IMPERR_UNSUUPORT_PAGE_TYPE; // unsupported page type
	}
		
	return 0; // success
}

static GraphPage GetTargetGraphPage(TreeNode &trFilter, LPCSTR lpcszWinName, string& strGraphPage)
{
	string strWinName ;
	if( lpcszWinName )
		strWinName = lpcszWinName;

	GraphPage pageGraph(strWinName);
*/
/// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
/*
#define GRAPH_ADD_PLOT(_Type_, _GraphLayer_) \
		_Type_ _ly = lyData; \
		_GraphLayer_.AddPlot(_ly, iPlotID); \
		break;
static int GraphData(GraphLayer& grLayer, int iPlotID, Layer &lyData)
{
	Page pageData;
	if ( lyData )
	{	
		lyData.GetParent(pageData);	
		switch( pageData.GetType() )
		{
		case EXIST_WKS:
			GRAPH_ADD_PLOT(Worksheet, grLayer)
		case EXIST_MATRIX:
			/// EJP 03-07-2003: Currently we can not get Matrix.  CP will fix.
			//GRAPH_ADD_PLOT(Matrix, grLayer)
			break;
		default:
			return IMPERR_UNSUUPORT_PAGE_TYPE; // unsupported page type
		}
	}		
	return 0; // success
}
*/
static int GraphData(GraphLayer& grLayer, int iPlotID, DataRange &orng)
{
	/// Hong 03/29/07 v8.0592 CLEAN_UP_PLOT_ONLY_SUPPORT_XY
	/*
	///---Sim 02-07-2007 ADD_RANGE_INFO
	DataRange drXY;
	//convert(drXY, orng);
	//unfinish
	drXY = orng;
	
	if ( grLayer && drXY )
	{
		/// Hong 03/29/07 v8.0592 FIX_FAIL_DRAG_AND_DROP_TO_GRAPH
		//grLayer.AddPlot(drXY, iPlotID);
		plot_wks_one_xy_from_data_range(drXY, grLayer, iPlotID);
		/// end FIX_FAIL_DRAG_AND_DROP_TO_GRAPH
		grLayer.Rescale();
	}
	///---END ADD_RANGE_INFO
	return 0; // success
	*/
	/// Hong 08/25/10 FIX_RUNTIME_ERROR_DRAG_AND_DROP_TO_GRAPH
	//if ( grLayer && orng )
	if ( grLayer && orng.IsValid() ) // Hong, temp fixed, later should fix VC level code, make if ( orng ) == if ( orng.IsValid() )
	/// end FIX_RUNTIME_ERROR_DRAG_AND_DROP_TO_GRAPH
	{
		plot_data_range(orng, grLayer, iPlotID);
		grLayer.Rescale();
	}		
		
	return 0; // success
	/// end CLEAN_UP_PLOT_ONLY_SUPPORT_XY
}
/// END ADD_DATA_RANGE_IN_XF_IMPORT_FILE
static GraphLayer CreateNewPageLayer(TreeNode &trFilter, string& strGraphPage)
{
	GraphLayer lyTarget;
	GraphPage pageGraph;
	string str;// = fuGetPlotTemplate(trFilter);
	//fuGetStr(&trFilter, IDE_FLT_PLOT_TEMPL, &str);
	fuGetRStr(trFilter, IDE_DISP_IMP_PLOTTEMPLATE, str);//Hong 8/29/06 MOVE_OFILTER_UTILS_TO_TREE_UTILS

	if( str.IsEmpty() )
		/// Hong 12/27/07 QA80-10541 FIX_IMPWIZ_SOME_PLOT_FAIL_CAUSE_BY_TEMPLATE
		//pageGraph.Create(); // default template
		/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
		//pageGraph.Create("origin"); // default template
		pageGraph.Create("origin", CREATE_DEFAULT_OPTIONS | CREATE_ENUM_EXIST_PAGE); // default template
		/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
		/// end FIX_IMPWIZ_SOME_PLOT_FAIL_CAUSE_BY_TEMPLATE
	else
		/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
		//pageGraph.Create(str);
		pageGraph.Create(str, CREATE_DEFAULT_OPTIONS | CREATE_ENUM_EXIST_PAGE);
		/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	
	if( pageGraph )
	{
		strGraphPage = pageGraph.GetName();
		lyTarget = pageGraph.Layers();
	}
	return lyTarget;
}
///---Sim 08-01-2006 CLEAR_CASE_FOR_GRAPH_IMPORT
#define CHECK_EMPTY_GRAPH_LAYER(_LayerGraph, _PageGraph) \
			if ( 0 == _PageGraph.Layers().DataPlots.Count() ) \
			{ \
				_LayerGraph = _PageGraph.Layers(); \
				break; \
			}
			
/// Hong 04/13/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
/////---Sim 08-01-2006 CLEAR_CASE_FOR_GRAPH_IMPORT
///// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
////static GraphLayer GetTargetGraphLayer(TreeNode &trFilter, string& strGraphPage, BOOL bSameFilter)
//static GraphLayer GetTargetGraphLayer(TreeNode &trFilter, string& strGraphPage, BOOL bSameFilter, BOOL bDropOnWkspace = FALSE)
///// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//{
	//GraphPage pageGraph(strGraphPage);
	//GraphLayer lyTarget; ///---Sim 08-01-2006 FOR_COUNT_DATAPLOT
	//int iDragDrop = FILTER_DDWORKSPACE_OPENONLY;
	//int nGraphLayer;
	///// Hong 9/01/06 GET_FILTER_BY_ID
	///*
	//if( trFilter.Common.DragAndDrop.Workspace &&
		//IS_FILTER_DDWORKSPACE(trFilter.Common.DragAndDrop.Workspace.nVal) )
	//{
		//iDragDrop = trFilter.Common.DragAndDrop.Workspace.nVal;
	//}
	//*/
	//TreeNode trWorkspace; 
	//trWorkspace = tree_get_node_by_id(trFilter, IDE_DNDIMP_WORKSPACE, true);
	//if( trWorkspace && IS_FILTER_DDWORKSPACE(trWorkspace.nVal) )
		//iDragDrop = trWorkspace.nVal;
	///// end GET_FILTER_BY_ID
	/////---Sim 08-01-2006 CLEAR_CASE_FOR_GRAPH_IMPORT
	///*
	//if(( iDragDrop == FILTER_DDWORKSPACE_PLOT_1LAYER ||
		//iDragDrop == FILTER_DDWORKSPACE_PLOT_MULTILAYER ) && !bSameFilter )
	//{
		//iDragDrop = FILTER_DDWORKSPACE_PLOT_MULTIWINDOW;  // for diff type data	files need put in diff window
	//}
	//*/
	/////---END CLEAR_CASE_FOR_GRAPH_IMPORT
///// END MORE_ON_IW_FILTER
	/////---Sim 08-01-2006 CLEAR_CASE_FOR_GRAPH_IMPORT
	//lyTarget.Detach();
	//if( !pageGraph && strGraphPage.IsEmpty() ) // if DragDrop on Workspace
	//{
		//if( iDragDrop != FILTER_DDWORKSPACE_OPENONLY )
		//{
			//return CreateNewPageLayer(trFilter, strGraphPage);
		//}
		//return lyTarget; // none of layer
	//}
	//
	//if( pageGraph ) // if DragDrop on Graph window
	//{
		////if( FILTER_DDGRAPH_OPENONLY == fuGetDragDropGraph(trFilter) )
		////	pageGraph.Detach(); // do not plot the data
		//
		//int nRet = FILTER_DDGRAPH_OPENONLY;
		///// Hong 9/01/06 GET_FILTER_BY_ID
		///*
		//if( trFilter.Common.DragAndDrop.Graph &&
			//IS_FILTER_DDGRAPH(trFilter.Common.DragAndDrop.Graph.nVal) )
		//{
			//nRet = trFilter.Common.DragAndDrop.Graph.nVal;
		//}
		//*/
		//TreeNode trGraph; 
		//trGraph = tree_get_node_by_id(trFilter, IDE_DNDIMP_GRAPH, true);
		//if( trGraph && IS_FILTER_DDWORKSPACE(trGraph.nVal) )
			//nRet = trGraph.nVal;
		///// Hong 9/01/06 GET_FILTER_BY_ID
		//if( FILTER_DDGRAPH_OPENONLY == nRet )
		/////---Sim 08-01-2006 NO_GRAPH_FOR_IMPORT
		//{
			////pageGraph.Detach(); // do not plot the data
			//return lyTarget;  // none of layer
		//}
		///// Hong 04/11/07 DRAG_AND_DROP_TO_GRAPH_NO_NEED_CARE_SPACE_OPTION
		///// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
		////else
		//else if ( !bDropOnWkspace )
		///// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
		//{
			//return pageGraph.Layers();
		//}
		///// end DRAG_AND_DROP_TO_GRAPH_NO_NEED_CARE_SPACE_OPTION
		//
		/////---END NO_GRAPH_FOR_IMPORT
		//
		//if(( iDragDrop == FILTER_DDWORKSPACE_PLOT_1LAYER ||
			//iDragDrop == FILTER_DDWORKSPACE_PLOT_MULTILAYER ) && !bSameFilter )
		//{
			//iDragDrop = FILTER_DDWORKSPACE_PLOT_MULTIWINDOW;  // for diff type data	files need put in diff window
		//}
	////else if( strGraphPage.IsEmpty() ) // if File Open or DragDrop on Workspace
	///// AW 07/31/06 MORE_ON_IW_FILTER
	///*
	//{
		////int iDragDrop = fuGetDragDropWorkspace(trFilter);
		//int iDragDrop = FILTER_DDWORKSPACE_OPENONLY;
		//if( trFilter.Common.DragAndDrop.Workspace &&
			//IS_FILTER_DDWORKSPACE(trFilter.Common.DragAndDrop.Workspace.nVal) )
		//{
			//iDragDrop = trFilter.Common.DragAndDrop.Workspace.nVal;
		//}
//
		//if( iDragDrop == FILTER_DDWORKSPACE_PLOT_1LAYER ||
			//iDragDrop == FILTER_DDWORKSPACE_PLOT_MULTILAYER )
		//{
			//GraphPage pgTemp(strGraphPage);
			//pageGraph = pgTemp;
		//}
//
		//if( !pageGraph && iDragDrop != FILTER_DDWORKSPACE_OPENONLY )
		//{
			//string str;// = fuGetPlotTemplate(trFilter);
			//fuGetStr(&trFilter, IDE_FLT_PLOT_TEMPL, &str);
//
			//if( str.IsEmpty() )
				//pageGraph.Create(); // default template
			//else
				//pageGraph.Create(str);
			//
			//if( pageGraph )
				//strGraphPage = pageGraph.GetName();	
		//}
	//} 
//
	//return pageGraph;
	//*/
	///*
	//{
		//if( iDragDrop != FILTER_DDWORKSPACE_OPENONLY )
		//{
			//return CreateNewPageLayer(trFilter, strGraphPage);
		//}
	//}
	//
	//if ( !lyTarget.IsValid() )
	//{
		//if ( pageGraph )
		//{
	//*/
		//switch (iDragDrop)
		//{
			//
		//case FILTER_DDWORKSPACE_PLOT_1LAYER:
			//lyTarget = pageGraph.Layers();  // get current layer
			//// need add object
			//break;
		//case FILTER_DDWORKSPACE_PLOT_MULTILAYER:
			//CHECK_EMPTY_GRAPH_LAYER(lyTarget, pageGraph);
			//nGraphLayer = pageGraph.AddLayer();
			//if ( nGraphLayer > 0)
				//lyTarget = pageGraph.Layers(nGraphLayer);	
			//break;
		//case FILTER_DDWORKSPACE_PLOT_MULTIWINDOW:
			//CHECK_EMPTY_GRAPH_LAYER(lyTarget, pageGraph);
			//return CreateNewPageLayer(trFilter, strGraphPage);
		//}
	//}
	//return lyTarget;
	/////---END CLEAR_CASE_FOR_GRAPH_IMPORT
	///// END MORE_ON_IW_FILTER
//}
static GraphLayer GetTargetGraphLayer(TreeNode &trFilter, string& strGraphPage, BOOL bSameFilter, BOOL bDropOnWkspace = FALSE)
{
	GraphPage 	pageGraph(strGraphPage);
	GraphLayer 	lyTarget;
	
	// drop to graph
	if ( !bDropOnWkspace )
	{
		if ( !pageGraph )
			return lyTarget;
		int 		nRet = FILTER_DDGRAPH_OPENONLY;
		TreeNode 	trGraph; 
		trGraph = tree_get_node_by_id(trFilter, IDE_DNDIMP_GRAPH, true);
		if( trGraph && IS_FILTER_DDWORKSPACE(trGraph.nVal) )
			nRet = trGraph.nVal;

		if( FILTER_DDGRAPH_OPENONLY == nRet )
			return lyTarget;
		
		return pageGraph.Layers();
	}
	
	// drop to workspace
	int 		iDragDrop = FILTER_DDWORKSPACE_OPENONLY;
	TreeNode 	trWorkspace; 
	trWorkspace = tree_get_node_by_id(trFilter, IDE_DNDIMP_WORKSPACE, true);
	if( trWorkspace && IS_FILTER_DDWORKSPACE(trWorkspace.nVal) )
		iDragDrop = trWorkspace.nVal;
	
	if ( FILTER_DDWORKSPACE_OPENONLY == iDragDrop )
		return lyTarget;
	
	if ( !pageGraph )
		return CreateNewPageLayer(trFilter, strGraphPage);
	
	if(( iDragDrop == FILTER_DDWORKSPACE_PLOT_1LAYER ||
		iDragDrop == FILTER_DDWORKSPACE_PLOT_MULTILAYER ) && !bSameFilter )
	{
		iDragDrop = FILTER_DDWORKSPACE_PLOT_MULTIWINDOW;  // for diff type data	files need put in diff window
	}

	switch (iDragDrop)
	{
	case FILTER_DDWORKSPACE_PLOT_1LAYER:
		lyTarget = pageGraph.Layers();  // get current layer
		// need add object
		break;
	case FILTER_DDWORKSPACE_PLOT_MULTILAYER:
		{
			CHECK_EMPTY_GRAPH_LAYER(lyTarget, pageGraph);
			int 	nGraphLayer = pageGraph.AddLayer();
			if ( nGraphLayer > 0)
				lyTarget = pageGraph.Layers(nGraphLayer);	
		}
		break;
	case FILTER_DDWORKSPACE_PLOT_MULTIWINDOW:
		CHECK_EMPTY_GRAPH_LAYER(lyTarget, pageGraph);
		return CreateNewPageLayer(trFilter, strGraphPage);
	}
	return lyTarget;
}
/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY


/// AW 05/21/07 FIX_USER_DEFINE_FILTER
BOOL find_node_by_name(TreeNode* ptrRoot, TreeNode& trReturnNode, LPCSTR lpcszNodeName, BOOL bRecursive)
{
	if ( ptrRoot )
	{
		trReturnNode = ptrRoot->GetNode(lpcszNodeName);
		if ( trReturnNode )
			return TRUE;
		if ( bRecursive )
		{
			foreach ( TreeNode trSubNode in ptrRoot->Children)
			{
				if ( trSubNode.GetNodeCount() > 0 )
					if ( find_node_by_name(&trSubNode, trReturnNode, lpcszNodeName, bRecursive) )
						return TRUE;
			}
		}
	}
	return FALSE;
}
/// END FIX_USER_DEFINE_FILTER


/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
/// Hong 9/28/06 MORE_ON_ADD_IMPFILE_XF
//static BOOL IsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile)
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL IsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes) // NULL
BOOL is_applicable_ex(TreeNode &trFilter, LPCSTR lpcszDataFile, LPCSTR lpcszTypes) // NULL
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
/// END MORE_ON_ADD_IMPFILE_XF
{
	///---Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	FUNC_ISAPPLICABLE fIsApplicable;
	fIsApplicable = Project.FindFunction(IMPORT_FUNC_NAME_IS_APPLICABLE, IMPORT_FUNC_PATH, true);
	ASSERT(fIsApplicable);	
	///---END QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	
	///---Sim 01-24-2007 CHECK_FILTER_INVALID
	if ( !trFilter )
		return false;
	///---END CHECK_FILTER_INVALID
	
	///  AW 07/21/06 NEW_IW_FILTER_FILE
	if ( 0 == trFilter.GetNodeCount() )  
		return false;
	/// END NEW_IW_FILTER_FILE
	
	if( NULL == lpcszDataFile )
		return TRUE; // no file name to compare

	string strDataFile = GetFileName(lpcszDataFile);
	if( strDataFile.IsEmpty() )
		return TRUE; // no file name to compare

	if( strDataFile.Find('.') == -1 ) // if no extension
		strDataFile += '.';

	string strFileSpecs;
	/// Hong 9/08/06 SUPPORT_ORIGIN75_FILTER
	/*
	//fuGetStr(&trFilter, IDE_FLT_FILE_SPEC, &strFileSpecs); // get applicability of filter
	fuGetRStr(trFilter, IDE_DISP_IMP_FILESPEC, strFileSpecs); //Hong 8/29/06 MOVE_OFILTER_UTILS_TO_TREE_UTILS
	*/
	/// EJP 2006-09-11 v8.0480 SUPPORT_ORIGIN75_FILTER
	///double dVersion = trFilter.OriginVersion.dVal;
	double dVersion = fuGetOriginVersion(trFilter);
	/// end SUPPORT_ORIGIN75_FILTER
	if(dVersion > 8.0473)
		strFileSpecs = fuGetApplicability(trFilter);
	else
	/// AW 05/21/07 FIX_USER_DEFINE_FILTER
	//	strFileSpecs = trFilter.Common.FileSpec.strVal;
	{
		/// Hong 05/22/07 v8.0623 MORE_FIX_USER_DEFINE_FILTER
		/*
		TreeNode trFileSpec;
		if ( find_node_by_name(&trFilter, trFileSpec, "FileSpec", TRUE) )
			strFileSpecs = trFileSpec.strVal;
		*/
		if ( trFilter.Common && trFilter.Common.FileSpec )
			strFileSpecs = trFilter.Common.FileSpec.strVal;
		/// end MORE_FIX_USER_DEFINE_FILTER
		else
			return FALSE;
	}
	/// END FIX_USER_DEFINE_FILTER
	/// end SUPPORT_ORIGIN75_FILTER

	StringArray saFileSpec;
	strFileSpecs.GetTokens(saFileSpec, ';');
	/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
	if( NULL == lpcszTypes )
	{
		for( int n = 0; n < saFileSpec.GetSize(); n++ )
		{
			/// Hong 11/20/06 FIX_IGNORE_INVALID_CHARACTER
			//if( strDataFile.Match(saFileSpec[n]) )
			string strFileSpec = saFileSpec[n];
			strFileSpec.TrimLeft();
			strFileSpec.TrimRight();
			if( strDataFile.Match(strFileSpec) )
			/// end FIX_IGNORE_INVALID_CHARACTER
				return TRUE;
		}
	}
	else
	{
		string strTypes(lpcszTypes);
		StringArray saFileTypes;
		strTypes.GetTokens(saFileTypes, ';');
		for( int ii=0; ii < saFileTypes.GetSize(); ii++ )
		{
			bool bMatch = false;
			for( int n = 0; n < saFileSpec.GetSize(); n++ )
			{
				string strType = saFileTypes[ii];
				strType.TrimLeft();
				strType.TrimRight();
				string strFileSpec = saFileSpec[n];
				strFileSpec.TrimLeft();
				strFileSpec.TrimRight();
				if( strType.Match(strFileSpec) )
				{	/// Hong 01/18/07 MORE_FOR_FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
					bMatch = true;
					saFileSpec.RemoveAt(n);
					n--;
					/// end MORE_FOR_FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
				}
			}
			if( !bMatch )
				return FALSE;
		}
		/// Hong 01/18/07 MORE_FOR_FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		if( saFileSpec.GetSize() > 0 )
			return FALSE;
		/// end MORE_FOR_FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		return TRUE;
	}
	/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
	return FALSE;
}
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//static int GetApplicableFilter(TreeNode &trFilterList, LPCSTR lpcszDataFile, TreeNode& trSubFilter, BOOL bUseSameFilter)
static int GetApplicableFilter(TreeNode &trFilterList, LPCSTR lpcszDataFile, TreeNode& trSubFilter, BOOL bUseSameFilter, LPCSTR lpcszTypes = NULL)
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
{
	if ( bUseSameFilter )
	{
		// we need check all existing trfilters
		int nIndex = 0;
		int nID, nPreID = -1;
		foreach (TreeNode trFilter in trFilterList.Children )
		{
			
			trFilter.GetAttribute("nID",nID) ;
			if ( nPreID == nID )
				continue;		// no need check same filter;
			/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			//if ( IsApplicable(trFilter, lpcszDataFile ) )
			///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
			//if ( IsApplicable(trFilter, lpcszDataFile, lpcszTypes) )
			if ( is_applicable_ex(trFilter, lpcszDataFile, lpcszTypes) )
			///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
			/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			{
				trSubFilter = trFilter;
				return nIndex;
			}
			nIndex++;
			nPreID = nID; ///---Sim 07-31-2006 STAY_PREVIOUS_ID
		}
	}
	return -1;
}

// TODO: LoadFilterFromPage is a utility function, should move out later
static BOOL LoadFilterFromPage(TreeNode &trFilter, Page &pgTarget, LPCSTR lpcszFilterType)
{
	
	if ( !pgTarget || !pgTarget.IsValid())
		return false;
	
	vector<byte> vb;
	if( pgTarget.GetMemory(lpcszFilterType, vb) )
	{
		string strFilter;
		if( strFilter.SetBytes(vb) )
		{
			trFilter.XML = strFilter;
			return true;
		}
	}
	return false;
}

///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
/*
#define LOAD_AND_CHECK_FILTER(_Type_) \
	if( fuLoadFilterFromPage(trFilter, pgTarget, _Type_) && \
		IsApplicable(trFilter, strFileName) ) \
	{ \
		saFilters.Add(saFilterTypeName[_Type_]); \
		trFilterList.AddNode(trFilter); \
		iCount++; \
	} 
*/
#define LOAD_AND_CHECK_FILTER(_Type_) \
	if( fuLoadFilterFromPage(trFilter, pgTarget, _Type_) && \
		is_applicable_ex(trFilter, strFileName) ) \
	{ \
		saFilters.Add(saFilterTypeName[_Type_]); \
		trFilterList.AddNode(trFilter); \
		iCount++; \
	} 
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	
static int GetFilterFromPage(string& strWinName, string& strFileName, StringArray& saFilters, TreeNode& trFilterList)
{	
	int iCount = 0;
	StringArray	saFilterTypeName ={STR_FILTER_TYPE_ASCII, STR_FILTER_TYPE_BINARY,
			STR_FILTER_TYPE_USERDEFINED,STR_FILTER_TYPE_XFUNC};

	Tree trFilter;
	Page pgTarget(strWinName);
	
	if ( !pgTarget || !pgTarget.IsValid())
		return false;

	LOAD_AND_CHECK_FILTER(FILTER_TYPE_ASCII)
	LOAD_AND_CHECK_FILTER(FILTER_TYPE_BINARY)
	LOAD_AND_CHECK_FILTER(FILTER_TYPE_USERDEFINED)
	LOAD_AND_CHECK_FILTER(FILTER_TYPE_XFUNC)
	
	return iCount;

}

//---Jake 07/12/07 CHECK_SUPPORT_D&D
/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
//static void pick_filter_supporting_drag_n_drop(StringArray& saFiltersInFolder,bool bSystemFolder)
static void pick_filter_supporting_drag_n_drop(StringArray& saFiltersInFolder, int nLocation)
/// end /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
{
	for(int ii = saFiltersInFolder.GetSize() - 1; ii >= 0; ii--)
	{
		//if(!is_drag_n_drop_supported(GetFileName(saFiltersInFolder[ii], TRUE), bSystemFolder))
		if(!is_drag_n_drop_supported(GetFileName(saFiltersInFolder[ii], TRUE), nLocation)) /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		{
			saFiltersInFolder.RemoveAt(ii);
		}
	}

	// case 2
	/*
	int ii = 0;
	while ( ii < saFiltersInFolder.GetSize() )
	{
		if(!is_drag_n_drop_supported(saFiltersInFolder[ii],bSystemFolder))
		{
			saFiltersInFolder.RemoveAt(ii);
		}
		else
			ii++;		
	}
	*/
}
//---end CHECK_SUPPORT_D&D

/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//static void GetFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile, TreeNode& trFilterList)
static void GetFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile, TreeNode& trFilterList, LPCSTR lpcszTypes = NULL)
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
{
	sarrFilterFiles.SetSize(0);
	
	string strFilterFileNames;
	GetFilenamesInFolder(strFilterFileNames, lpcszFolderPath, IMPORT_FILTER_EXTENSION_WILD, FALSE);
	if( strFilterFileNames.IsEmpty() )
		return;

	StringArray sarrFilterFileNames;
	strFilterFileNames.GetTokens(sarrFilterFileNames, '|');

	/// AW ????? I can't find a real case fit into the following codes, so I comment it out
	// TODO: Sim, please pay some time if you can find out a real case why need these codes
	/*
	string strApplicability;
	if( lpcszDataFile )
		strApplicability = GetFileName(lpcszDataFile);
	
	if( strApplicability.IsEmpty() )  // iDataType == FILTER_TYPE_IGNORE)
	{
		///sarrFilterFiles = sarrFilterFileNames;
		//sarrFilterFiles.Append(sarrFilterFileNames);
		for( int iFile = 0; iFile < sarrFilterFileNames.GetSize(); iFile++ )
			sarrFilterFiles.Add(sarrFilterFileNames[iFile]);
		return;
	}
	*/
	//// END AW ????

	for( int iFile = 0; iFile < sarrFilterFileNames.GetSize(); iFile++ )
	{
		Tree trFilter(sarrFilterFileNames[iFile]);
		/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		//if( trFilter && IsApplicable(trFilter, lpcszDataFile) )
		///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		//if( trFilter && IsApplicable(trFilter, lpcszDataFile, lpcszTypes) )
		if( trFilter && is_applicable_ex(trFilter, lpcszDataFile, lpcszTypes) )
		///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		{
			sarrFilterFiles.Add(sarrFilterFileNames[iFile]);
			trFilterList.AddNode(trFilter);
		}
	}
}

///---Sim 01-24-2007 SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE

//static bool mode_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
//{
	//int nEnable;
	//if ( 0 == trNode.nVal )
	//{
		//nEnable = 1;
	//}
	//else if ( 1 == trNode.nVal )
	//{
		//nEnable = 0;
	//}
	//else
		//return false;
	//
	////myTree.useSameFilter.Enable = nEnable;
	//myTree.FolderMode.Enable = nEnable;
	//myTree.FilterList.Enable = nEnable;
		//
	//return true;
//}
/*
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//static int GetFilter(TreeNode& trFilterRet, string& strFullFileName , string& strWinName, BOOL& bUseSameFilter)
static int GetFilter(TreeNode& trFilterRet, string& strFullFileName , string& strWinName, BOOL& bUseSameFilter, LPCSTR lpcszTypes = NULL)
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
{
	Tree trFilterList;
	string strFileName = GetFileName(strFullFileName);
	
	StringArray saFilters;	/// AW 07/20/06 USING_IW_FILTER_C 
	
	int nSelected = 0;   	////  AW 08/23/06 ADD_FILTER_FILENAME
	
	// first check filter in page, if find applicable filter no need check folders
	int nCount = GetFilterFromPage(strWinName, strFileName, saFilters, trFilterList);
	if ( 0 == nCount )
	{
		// no filter in page, check the folders
		
		// first check data file folder, if find applicable filter no need check origin folder 
		StringArray saFiltersInDataFolder;
		string strDataPath = GetFilePath(strFullFileName);
		if( !strDataPath.IsEmpty() )
			/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			//GetFilterFiles(saFilters, strDataPath, strFileName, trFilterList);
			GetFilterFiles(saFilters, strDataPath, strFileName, trFilterList, lpcszTypes);
			/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
	
		nCount = saFilters.GetSize();  //// AW 07/27/06 NEW_IW_FILTER_TO_DO
		if( 0 == nCount ) 
		{
			// if no applicable filters in data-folder then check ini and exe folders.
			
			// check exe folder
			StringArray saFiltersInExeFolder;
			string strExePath;
			strExePath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
			if( !strExePath.IsEmpty() && strExePath != strDataPath )
				/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
				//GetFilterFiles(saFiltersInExeFolder, strExePath, strFileName, trFilterList);
				GetFilterFiles(saFiltersInExeFolder, strExePath, strFileName, trFilterList, lpcszTypes);
				/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			nCount = saFiltersInExeFolder.GetSize();  //// AW 07/27/06 NEW_IW_FILTER_TO_DO
			saFilters = saFiltersInExeFolder;
			
			// check user folder
			StringArray saFiltersInUserFolder;
			string strIniPath;
			strIniPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
			if( !strIniPath.IsEmpty() && strIniPath != strDataPath && strIniPath != strExePath )
				/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
				//GetFilterFiles(saFiltersInUserFolder, strIniPath, strFileName, trFilterList);	
				GetFilterFiles(saFiltersInUserFolder, strIniPath, strFileName, trFilterList, lpcszTypes);	
				/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			nCount += saFiltersInUserFolder.GetSize();
			saFilters.Append(saFiltersInUserFolder);
		}
	}
	////  AW 08/23/06 ADD_FILTER_FILENAME
	else
	{
		saFilters.Add("Filter in the current Page");	
.	}
	//// END ADD_FILTER_FILENAME

	///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
	if ( 0 == nCount )
	{
		return IMPERR_NO_FILTER;
		//return IMP_IMPWIZ;
		//saFilters.Add("No filter specified");
	}
	else if ( nCount == 1 )
	{
		trFilterRet = trFilterList.FirstNode;
	}
	else if ( nCount > 1 )
	{
	///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		//int nSelected = 0;   	////  AW 08/23/06 ADD_FILTER_FILENAME
		
		string strCombo;
		strCombo.SetTokens(saFilters, '|');
		GETN_BOX(tr);
		string strDesc = "Pick a filter for file : ";
		//strDesc += strFullFileName;
		strDesc += GetFileName(strFullFileName); // Hong 01/03/06 ONLY_FILENAME_IS_ENOUGH
	 	///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		//GETN_RADIO_INDEX(mode, 0, "Use Filter|Use Import Wizard For All Files") 
			//GETN_OPTION_EVENT_EX(mode_event)
			//GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
	 	///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		GETN_CHECK(useSameFilter, "Use Same Filter for the Following Files", bUseSameFilter) ///---Sim 01-03-2007 GET_GOOD_NAME
		GETN_LISTBOX(item, "", 0, strCombo)		
		///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		//if( GetNBox( tr, "Select Filter", strDesc ))
		if ( !GetNBox( tr, "Select Filter", strDesc ) )
		{
			//nSelected = tr.item.nVal;
			//bUseSameFilter = tr.useSameFilter.nVal;
		//}
		//else
		//{
			return IMP_USER_CANCEL;  //need define this
		}
		//if ( 1 == tr.mode.nVal ) // use import wizard
		//{
			//return IMP_IMPWIZ;
		//}
		
		// selected filter
		//if ( 0 == nCount ) // number of filter list
			//return IMPERR_NO_FILTER;
		
		nSelected = tr.item.nVal;
		bUseSameFilter = tr.useSameFilter.nVal;
		ASSERT(nSelected < trFilterList.GetNodeCount());
		trFilterRet = trFilterList.Children.Item(nSelected);
	}
	
	trFilterRet.FileName.strVal = saFilters[nSelected];  	////  AW 08/23/06 ADD_FILTER_FILENAME
	///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
	
	return IMPERR_NONE;
}
*/

enum {
	FILTER_ALL = 0,
	FILTER_IN_DATA_FOLDER,
	FILTER_IN_USER_FOLDER,
	FILTER_IN_ORIGIN_FOLDER,
	FILTER_IN_GROUP_FOLDER, /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	
};

//static bool folder_mode_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
//{
	//StringArray saFilters;
		//
	//switch ( trNode.nVal )
	//{
	//case FILTER_ALL:
		//saFilters = myTree.AllFilters.AllFolder.strVals;
		//break;
	//case FILTER_IN_DATA_FOLDER:
		//saFilters = myTree.AllFilters.DataFolder.strVals;
		//break;
	//case FILTER_IN_USER_FOLDER:
		//saFilters = myTree.AllFilters.UserFolder.strVals;
		//break;
	//case FILTER_IN_ORIGIN_FOLDER:
		//saFilters = myTree.AllFilters.ExeFolder.strVals;
		//break;
	//default:
		//return false;
	//}
//
	//string strFilterList;
	//strFilterList.SetTokens(saFilters, '|');
	//myTree.FilterList.SetAttribute(STR_COMBO_ATTRIB, strFilterList);
	//
	//if ( 0 == saFilters.GetSize() )
	//{	// no filter display, disable ok button
		//Dialog 	*pdlg = (Dialog*)&theDlg;
		//if ( pdlg )
		//{
			//Control btnOK = pdlg->GetItem(IDOK);
			//btnOK.Enable = false; //==> unwork
		//}
	//}
	//
	//return true;
//}
//
static bool s_bIsEmptyFilterList;

static int filter_selecter_getn_event(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES
	bOKEnable = !s_bIsEmptyFilterList;
	//if ( 0 == strcmp(lpcszNodeName, "mode") )
	//{
		//int nEnable;
		//if ( 0 == tr.mode.nVal ) // filter mode
		//{	
			//nEnable = 1;
			//
			//// check filter list
			//string strFilterList;
			//tr.FilterList.GetAttribute(STR_COMBO_ATTRIB, strFilterList);
			//
			//if ( strFilterList.IsEmpty() )
			//{	// no filter display, disable ok button
				//bOKEnable = false;
			//}
		//}
		//else if ( 1 == tr.mode.nVal ) // importwizard mode
		//{
			//nEnable = 0;
		//}
		//else
			//return false;
		//
		////myTree.useSameFilter.Enable = nEnable;
		//tr.FolderMode.Enable = nEnable;
		//tr.FilterList.Enable = nEnable;
			//
		//return true;
	//}
	if(nEvent == GETNE_ON_INIT)
	{
		//SET_APPLY_BUTTTON_TEXT(strAux, "ImportWizard");
		///---Sim 03-24-2007 FIX_CUSTOM_BUTTON
		//tr.SetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, "Ok|Import Wizard");
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		//tr.SetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, _L("Import Wizard"));
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		///---END FIX_CUSTOM_BUTTON
		return true;
	}
	//if(nEvent == GETNE_ON_APPLY)
	//{
		//return PEVENT_GETN_RET_APPLY_TO_CLOSE;
	//}
	if(nEvent == GETNE_ON_CUSTOM_BUTTON1)
	{
		return PEVENT_GETN_RET_TO_CLOSE;
	}
	
	if ( 0 == strcmp(lpcszNodeName, "FolderMode") )
	{
		StringArray saFilters;
			
		switch ( tr.FolderMode.nVal )
		{
		case FILTER_ALL:
			saFilters = tr.AllFilters.AllFolder.strVals;
			break;
		case FILTER_IN_DATA_FOLDER:
			saFilters = tr.AllFilters.DataFolder.strVals;
			break;
		case FILTER_IN_USER_FOLDER:
			saFilters = tr.AllFilters.UserFolder.strVals;
			break;
		case FILTER_IN_ORIGIN_FOLDER:
			saFilters = tr.AllFilters.ExeFolder.strVals;
			break;
		/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	
		case FILTER_IN_GROUP_FOLDER:
			saFilters = tr.AllFilters.GroupFolder.strVals;
			break;
		/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	
		default:
			return false;
		}
	
		string strFilterList;
		strFilterList.SetTokens(saFilters, '|');
		tr.FilterList.SetAttribute(STR_COMBO_ATTRIB, strFilterList);
		
		// no filter display, disable ok button
		s_bIsEmptyFilterList = strFilterList.IsEmpty();	// static var for next event
		bOKEnable = s_bIsEmptyFilterList;
		
		return true;
	}
	
	/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	if ( 0 == lstrcmpi(lpcszNodeName, "SaveFilter") )
	{
		tr.UseSameFilter.Enable = tr.SaveFilter.nVal ? DISABLE : ENABLE;
	}
	/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	
	return false;
}

///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
static	BOOL	_check_get_last_import_settings(TreeNode& trSettings, LPCSTR lpcszWinName)
{
	Page		pg(lpcszWinName);
	if ( !pg )
		return FALSE;
	
	Tree trBinary;
	if( !tree_get_binary_storage(trBinary, pg, IFI_BINARY_STORAGE_NAME) )
		return FALSE;
	
	TreeNode	trFile1 = trBinary.FirstNode;
	TreeNode	trFileLast=trFile1;
	for ( ; trFile1; trFileLast=trFile1, trFile1=trFile1.NextNode );
	
	if ( !trFileLast )
		return FALSE;
	
	trSettings = trFileLast.FilterInfo;
	return trSettings.IsValid();
}

static	BOOL	_check_make_single_filter(StringArray& saFilters, LPCSTR lpcszWinName)
{
	TreeNode	trSettings;
	if ( !_check_get_last_import_settings(trSettings, lpcszWinName) )
		return FALSE;

	TreeNode	trASCIMP = trSettings.ASCIMP;
	TreeNode	trXFunction = trSettings.XFunction;
	
	int		nSelected = -1;
	for ( int ii=0; nSelected<0 && ii<saFilters.GetSize(); ++ii )
	{
		Tree	trFilter;
		fuLoad(trFilter, saFilters[ii]);

		if ( (trXFunction && trFilter.XFunction && trFilter.XFunction.strName.strVal.CompareNoCase(trXFunction.Name.strVal) == 0)
			|| (trASCIMP && trFilter.ASCIMP)
			)
		{
			nSelected = ii;
		}
	}

	if ( nSelected >= 0 )
	{
		saFilters[0] = saFilters[nSelected];
		saFilters.SetSize(1);
		return TRUE;
	}

	return FALSE;
}

///------ End BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT

///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
//static int GetFilter(Tree& trFilterRet, string& strFullFileName , string& strWinName, BOOL& bUseSameFilter, LPCSTR lpcszTypes = NULL)
/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
//static int GetFilter(Tree& trFilterRet, string& strFullFileName , string& strWinName, BOOL& bUseSameFilter, LPCSTR lpcszTypes = NULL, bool bIgnoreDragNDropSupport = false)
static int GetFilter(Tree& trFilterRet, string& strFullFileName , string& strWinName, BOOL& bUseSameFilter, LPCSTR lpcszTypes = NULL, DWORD dwCntrl = 0)
/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
{
	///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
	int		nReturn = IMPERR_NONE;
	///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
	Tree trFilterList;
	string strFileName = GetFileName(strFullFileName);
	
	string strFilterName;
	StringArray saFilters;
	StringArray saFiltersInDataFolder;
	StringArray saFiltersInUserFolder;
	StringArray saFiltersInExeFolder;
	StringArray saFiltersInGroupFolder; /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
	
	/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	bool 	bIgnoreDragNDropSupport = (IMPORT_FILES_IGNORE_DRAG_AND_DROP_SUPPORT & dwCntrl) ? true : false;
	bool 	bSaveFilterIntoPage = false;
	/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING

	///---Sim 04-10-2007 FIX_GET_FILTER_FROM_SHEET_STORAGE
	int nSelected = 0;
	bool bFilterInSheet = false;
	// first check filter in page, if find applicable filter no need check folders
	int nCount = GetFilterFromPage(strWinName, strFileName, saFilters, trFilterList);
	if ( nCount > 0 )
	{
		//ASSERT(1 == nCount);
		//nCount = 1;
		bFilterInSheet = true;
	}
	else // ( 0 == nCount )
	{	// no filter in page, check the folders
		
		// first check data file folder, if find applicable filter no need check origin folder 
		string strDataPath = GetFilePath(strFullFileName);
		if( !strDataPath.IsEmpty() )
			GetFilterFiles(saFiltersInDataFolder, strDataPath, strFileName, trFilterList, lpcszTypes);
		saFilters = saFiltersInDataFolder;
	
		nCount = saFilters.GetSize();
		if( 1 != nCount ) 
		{
			// if no applicable filters in data-folder then check ini and exe folders.
			
			// check user folder
			string strIniPath;
			strIniPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
			if( !strIniPath.IsEmpty() && strIniPath != strDataPath )
				GetFilterFiles(saFiltersInUserFolder, strIniPath, strFileName, trFilterList, lpcszTypes);	
			if ( !bIgnoreDragNDropSupport )		///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
				pick_filter_supporting_drag_n_drop(saFiltersInUserFolder,false);///Jake 07/12/07 CHECK_SUPPORT_D&D
			nCount += saFiltersInUserFolder.GetSize();
			saFilters.Append(saFiltersInUserFolder);
			
			// check exe folder
			string strExePath;
			strExePath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
			if( !strExePath.IsEmpty() && strExePath != strDataPath && strExePath != strIniPath )
				GetFilterFiles(saFiltersInExeFolder, strExePath, strFileName, trFilterList, lpcszTypes);
			if ( !bIgnoreDragNDropSupport )		///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
				pick_filter_supporting_drag_n_drop(saFiltersInExeFolder,true);///Jake 07/12/07 CHECK_SUPPORT_D&D
			nCount += saFiltersInExeFolder.GetSize();
			saFilters.Append(saFiltersInExeFolder);
			
			/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
			// check group folder
			string strGroupPath;
			/// Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY
			//strGroupPath.Format("%s%s", okutil_get_origin_path(ORIGIN_PATH_GROUP), FILTERS_FOLDER_NAME);
			strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
			if ( !strGroupPath.IsEmpty() )
			{
				strGroupPath.Format("%s%s", strGroupPath, FILTERS_FOLDER_NAME);
			/// end GROUP_PATH_CAN_BE_EMPTY
				if( !strGroupPath.IsEmpty() && strGroupPath != strDataPath && strGroupPath != strIniPath )
					GetFilterFiles(saFiltersInGroupFolder, strGroupPath, strFileName, trFilterList, lpcszTypes);
				if ( !bIgnoreDragNDropSupport )		///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
					pick_filter_supporting_drag_n_drop(saFiltersInGroupFolder,FILTER_LOCATION_GROUP_FOLDER);
				nCount += saFiltersInGroupFolder.GetSize();
				saFilters.Append(saFiltersInGroupFolder);
			}
			/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP

			///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
			if ( (nCount > 1) && (IMPORT_FILES_CHECK_USE_LAST_IMPORT_SETTINGS & dwCntrl) )
			{
				if ( _check_make_single_filter(saFilters, strWinName) )
					nCount = saFilters.GetSize();
			}
			///------ End BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
		}
	}

	if ( 0 == nCount )
	{
		///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
		if ( O_QUERY_BOOL(dwCntrl, IMPORT_FILES_FORCE_ASCII_FILTER_IF_NONE) )
		{
			strFilterName = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, FILTERS_FOLDER_NAME) + "ASCII.oif";
			nReturn = IMPERR_FORCE_ASCII_FILTER;
		}
		else
		///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
		return IMPERR_NO_FILTER;
	}
	else if ( nCount == 1 )
	{
		//trFilterRet = trFilterList.FirstNode;
		strFilterName = saFilters[nSelected]; // nSelected is 0
	}
	else if ( nCount > 1 )
	{
		GETN_BOX(tr);
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		if ( !(IMPORT_FILES_SEL_FILTER_DLG_HIDE_IMP_WIZ_BTN & dwCntrl) )
			tr.SetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, _L("Import Wizard"));
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	 	///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		//GETN_RADIO_INDEX(mode, 0, "Use Filter|Use Import Wizard") 
			//GETN_OPTION_EVENT_EX(mode_event)
			//GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)
	 	///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
	 	
	 	// for store filter list
		TreeNode trAllFilters = tr.AddNode("AllFilters");
		trAllFilters.AllFolder.strVals = saFilters;
		trAllFilters.DataFolder.strVals = saFiltersInDataFolder;
		trAllFilters.UserFolder.strVals = saFiltersInUserFolder;
		trAllFilters.ExeFolder.strVals = saFiltersInExeFolder;
		trAllFilters.GroupFolder.strVals = saFiltersInGroupFolder; /// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		trAllFilters.Show = 0;
		
		string strFolderMode;
		if ( bFilterInSheet )
			strFolderMode = _L("Show All Filters in Sheet Storage");
		else
			/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
			//strFolderMode = "Show All Filters|Filters in Data Folder|Filters in User Folder|Filters in Origin Folder";
			/// Hong 09/30/07 v8.0711c GROUP_PATH_CAN_BE_EMPTY			
			//strFolderMode = "Show All Filters|Filters in Data Folder|Filters in User Folder|Filters in Origin Folder|Filters in Group Folder";
			{				
				strFolderMode = _L("Show All Filters|Filters in Data Folder|Filters in User Folder|Filters in Origin Folder");
				string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
				if ( !strGroupPath.IsEmpty() )
					strFolderMode += _L("|Filters in Group Folder");
			}
			/// end GROUP_PATH_CAN_BE_EMPTY
			/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
			
		//GETN_LIST(FolderMode, "", 0, "Show All Filters|Filters in Data Folder|Filters in User Folder|Filters in Origin Folder")
		GETN_LIST(FolderMode, "", 0, strFolderMode)
			GETN_OPTION_NUM_FORMAT( "%d" )
			//GETN_OPTION_EVENT_EX(folder_mode_event)
			
		string strFilterList;
		strFilterList.SetTokens(saFilters, '|');
		GETN_LISTBOX(FilterList, "", 0, strFilterList)
		
		// comment following line temporarily
		//GETN_CHECK(UseSameFilter, "Apply this filter on the residual matched files", bUseSameFilter)
		///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
		if ( !(IMPORT_FILES_SEL_FILTER_DLG_NO_APPLY_TO_ALL & dwCntrl) )
		///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
		{
			GETN_CHECK(UseSameFilter, _L("Apply this filter on the rest of the files that match the filter"), bUseSameFilter)
		}
		else
		{
			GETN_STR(Junk, _L("The selected filter will be applied to the rest of files"), "")
			GETN_READ_ONLY_COLOR
			GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL | DISPLAY_EDITOR_BOLD_FONT)
			bUseSameFilter = TRUE;
		}
		
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		if ( IMPORT_FILES_SEL_FILTER_DLG_SHOW_SAVE_TO_PAGE_CHKBX & dwCntrl )
		{
			GETN_CHECK(SaveFilter, _L("Save this filter into the window"), 0);
			GETN_STR(Junk, _L("You can save the window later if you want to keep using this filter for the window"), "") GETN_HINT
		}
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		
		string strDesc;
		strDesc += _L("Pick a filter for : ");
		strDesc += GetFileName(strFullFileName);
		s_bIsEmptyFilterList = false; // for ok enable
		int nRet = GetNBox(tr, filter_selecter_getn_event, _L("Select Filter"), strDesc);
		if ( 0 == nRet ) // 0 means on click cancel button
		{
			return IMP_USER_CANCEL;  //need define this
		}
		
		///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
		if ( tr.UseSameFilter )
		///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
			bUseSameFilter = tr.UseSameFilter.nVal;

		if ( IDC_GETN_CUSTOM_BTN1 == nRet )	// click import wizard button
			return IMP_IMPWIZ;
		
		// selected a filter
		nSelected = tr.FilterList.nVal;
		int nFolderMode = tr.FolderMode.nVal;
		switch ( nFolderMode )
		{
			case FILTER_ALL:
				if ( nSelected >= saFilters.GetSize() )
					return IMPERR_NO_FILTER;
				strFilterName = saFilters[nSelected];
				break;
			case FILTER_IN_DATA_FOLDER:
				if ( nSelected >= saFiltersInDataFolder.GetSize() )
					return IMPERR_NO_FILTER;
				strFilterName = saFiltersInDataFolder[nSelected];
				break;
			case FILTER_IN_USER_FOLDER:
				if ( nSelected >= saFiltersInUserFolder.GetSize() )
					return IMPERR_NO_FILTER;
				strFilterName = saFiltersInUserFolder[nSelected];
				break;
			case FILTER_IN_ORIGIN_FOLDER:
				if ( nSelected >= saFiltersInExeFolder.GetSize() )
					return IMPERR_NO_FILTER;
				strFilterName = saFiltersInExeFolder[nSelected];
				break;
			/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
			case FILTER_IN_GROUP_FOLDER:
				if ( nSelected >= saFiltersInGroupFolder.GetSize() )
					return IMPERR_NO_FILTER;
				strFilterName = saFiltersInGroupFolder[nSelected];
				break;			
			/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
		}
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		if ( tr.SaveFilter && 1 == tr.SaveFilter.nVal )
			bSaveFilterIntoPage = true;
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	}
	
	if ( !bFilterInSheet )
	{
		fuLoad(trFilterRet, strFilterName);
		trFilterRet.FileName.strVal = strFilterName;
	}
	else
	{
		trFilterRet = trFilterList.Children.Item(nSelected); // filter in sheet not has filename
		trFilterRet.FileName.strVal = strWinName + "_" + strFilterName;
	}
	///---END FIX_GET_FILTER_FROM_SHEET_STORAGE
	/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	if ( bSaveFilterIntoPage )
	{
		Page 	pgTarget(strWinName);
		if ( pgTarget )
			fuSaveFilterToPage(trFilterRet, pgTarget);
	}
	/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
	
	///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
	//return IMPERR_NONE;
	return nReturn;
	///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
}

///---END SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE

// also sort 2 lists
///---Sim 01-05-2006 SUPPORT_NO_FILTER
//static int GetFilters(StringArray& stDataFileName, TreeNode& trFilterList, string& strWinName)
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//static int GetFilters(StringArray& stDataFileName, StringArray& stNoFilterFiles, TreeNode& trFilterList, string& strWinName)
static int GetFilters(StringArray& stDataFileName, StringArray& stNoFilterFiles, TreeNode& trFilterList, string& strWinName, LPCSTR lpcszTypes = NULL)
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
///---END SUPPORT_NO_FILTER
{
	int 	nRet;
	string 	strFullFileName;
	Tree 	trFilter;
	///---Sim 08-01-2006 DEFAULT_USING_SAME_FILTER
	//BOOL	bUseSameFilter = false;
	BOOL	bUseSameFilter = true;
	///---END DEFAULT_USING_SAME_FILTER
	int 	nNumFiles = stDataFileName.GetSize();
	TreeNode trApplicableNode, trTempNode;
	StringArray	stNewDataFileNames;
	int 	nIndexSubNode, nID = 0;
	
	for (int ii = 0 ;ii < nNumFiles; ii++ )
	{
		strFullFileName = stDataFileName[ii];
		/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		//nIndexSubNode = GetApplicableFilter(trFilterList, strFullFileName, trApplicableNode, bUseSameFilter);
		nIndexSubNode = GetApplicableFilter(trFilterList, strFullFileName, trApplicableNode, bUseSameFilter, lpcszTypes);
		/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
		if( 0 <= nIndexSubNode )
		{
			trTempNode = trFilterList.InsertNode(trApplicableNode, "junk");
			trTempNode.Replace(trApplicableNode);
			stNewDataFileNames.InsertAt(nIndexSubNode, strFullFileName);
		}
		else
		{  
			// trFilter is not applicable to the data file
			///---Sim 01-05-2006 SUPPORT_NO_FILTER
			/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			//if ( nRet = GetFilter(trFilter, strFullFileName, strWinName, bUseSameFilter) )
			if ( nRet = GetFilter(trFilter, strFullFileName, strWinName, bUseSameFilter, lpcszTypes) )
			/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
			{
				if ( IMPERR_NO_FILTER == nRet )
				{
					stNoFilterFiles.Add(strFullFileName);
					continue;
				}
				return nRet; // user cancel
			}
			///---END SUPPORT_NO_FILTER
			trFilter.SetAttribute("nID", nID++);
			trFilterList.AddNode(trFilter);
			stNewDataFileNames.Add(strFullFileName);
		}
	}
	stDataFileName = stNewDataFileNames;
	return IMPERR_NONE;
}

///---Sim 10-23-2008 QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER
bool updateFilterFromSheetTheme(TreeNode& trFilter, string& strWinName)
{
	Page pgTarget(strWinName);
	if ( !pgTarget || !pgTarget.IsValid())
		return false;
	Layer lyTarget = pgTarget.Layers();
	if ( !lyTarget || !lyTarget.IsValid())
		return false;
	///------ Folger 10/19/09 QA80-14459 BATCH_PROCESS_OPEN_OGW_HIDDENLY
	//page_set_active_layer(pgTarget, lyTarget.GetIndex(), false);
	///------ End BATCH_PROCESS_OPEN_OGW_HIDDENLY
	
	Tree tr;
	Tree trTheme;
	string strClassOption;
	int nType = fuGetType(trFilter);
	switch (nType)
	{
	case FILTER_TYPE_ASCII:
		strClassOption = "impAsc"; // hard code for xfunction name!!! reimport and filter manager use this name too.
		///------ Folger 10/19/09 QA80-14459 BATCH_PROCESS_OPEN_OGW_HIDDENLY
		//if ( !theme_active_book_sheet_storage(tr, strClassOption, PDS_SHEET, true, trTheme) )
		if ( !theme_active_book_sheet_storage(tr, strClassOption, PDS_SHEET, true, trTheme, &lyTarget) )
		///------ End BATCH_PROCESS_OPEN_OGW_HIDDENLY
			return false;
		if ( !trTheme.options )
			return false;
		
		OptionsToFilter(trTheme.options, trFilter);
		break;
	case FILTER_TYPE_XFUNC:
		if( !fuGetXFunctionName(trFilter, strClassOption) )
			return false;
		///------ Folger 10/19/09 QA80-14459 BATCH_PROCESS_OPEN_OGW_HIDDENLY
		//if ( !theme_active_book_sheet_storage(tr, strClassOption, PDS_SHEET, true, trTheme) )
		if ( !theme_active_book_sheet_storage(tr, strClassOption, PDS_SHEET, true, trTheme, &lyTarget) )
		///------ End BATCH_PROCESS_OPEN_OGW_HIDDENLY
			return false;
		///---Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
		update_getn_LT_variables(trTheme, strClassOption, true);
		///---END v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
		if ( !trTheme.options )
			return false;
		
		// keep file applicable extension info in filter, for then get applicable files list to import
		TreeNode trSpec = tree_get_node_by_id(trTheme.options, IDE_DISP_IMP_FILESPEC, true);
		if ( trSpec )
			trSpec.Remove();
		
		///---Sim 12-15-2008 QA80-12487-P1 FIX_OLD_FILTER_MISS_NEWEST_THEME_SETTING
		//tree_copy_values_by_id(trTheme.options, trFilter);
		tree_whole_copy_values_by_id(trTheme.options, trFilter);
		if ( trFilter.options )
			trFilter.options.Remove(); // exclude branch node
		///---END QA80-12487-P1 FIX_OLD_FILTER_MISS_NEWEST_THEME_SETTING
		break;
	default:
		return false;
	}
	
	string strRange;
	lyTarget.GetRangeString(strRange);
	
	trFilter.FileName.strVal = strRange + "_" + strClassOption + "_" + STR_SHEET;
	
	return true;
}
///---END QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER

///---Sim 01-24-2007 SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE
//static int GetOneFilters(TreeNode& trFilter, string& strDataFileName, string& strWinName, BOOL bSameExtension, BOOL& bUseSameFilter, BOOL& bSameFilter, LPCSTR lpcszTypes = NULL)
///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
//static int GetOneFilters(Tree& trFilter, string& strDataFileName, string& strWinName, BOOL& bUseSameFilter, BOOL& bSameFilter, LPCSTR lpcszTypes = NULL)
/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
//static int GetOneFilters(Tree& trFilter, string& strDataFileName, string& strWinName, BOOL& bUseSameFilter, BOOL& bSameFilter, LPCSTR lpcszTypes = NULL, bool bIgnoreDragNDropSupport = false)
static int GetOneFilters(Tree& trFilter, string& strDataFileName, string& strWinName, BOOL& bUseSameFilter, BOOL& bSameFilter, LPCSTR lpcszTypes = NULL, DWORD dwCntrl = 0)
/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
{
	int nRet = IMPERR_NONE;
	
	//bool bApplicableFilter = ( (bSameExtension || bUseSameFilter) && IsApplicable(trFilter, strDataFileName, lpcszTypes) );
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	//bool bApplicableFilter = ( bUseSameFilter && IsApplicable(trFilter, strDataFileName, lpcszTypes) );
	bool bApplicableFilter = ( bUseSameFilter && is_applicable_ex(trFilter, strDataFileName, lpcszTypes) );
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	bSameFilter = bApplicableFilter;
	
	if ( !bApplicableFilter )
	{
		Tree trNewFilter;
		///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
		//nRet = GetFilter(trNewFilter, strDataFileName, strWinName, bUseSameFilter, lpcszTypes);
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		//nRet = GetFilter(trNewFilter, strDataFileName, strWinName, bUseSameFilter, lpcszTypes, bIgnoreDragNDropSupport);
		nRet = GetFilter(trNewFilter, strDataFileName, strWinName, bUseSameFilter, lpcszTypes, dwCntrl);
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
		
		if ( IMPERR_NO_FILTER == nRet )
		{	// no filter
			string strFileNames;
			///---Sim 07-17-2007 FILTER_MANAGER_TOOLS
			//strFileNames.Format("No matched filters are found. Do you want to use Import Wizard to Import them?\n%s", strDataFileName);
			strFileNames.Format(_L("No matched filters found or the D&D feature of the related filter is turned off.\n"\
				"You can go to Tools|Import Filters Manager to turn on D&D of the filters.\n"\
				"Do you now want to use Import Wizard to Import them?\n%s"), strDataFileName);
			///---END FILTER_MANAGER_TOOLS
			if ( IDOK == MessageBox(GetWindow(), strFileNames, "Question", MB_OK|MB_OKCANCEL|MB_ICONQUESTION) )
			{
				nRet = IMP_IMPWIZ;
			}
		}
		else
		///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
		//if ( IMPERR_NONE == nRet )
		if ( IMPERR_NONE == nRet || IMPERR_FORCE_ASCII_FILTER == nRet )
		///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
		{	// has filter
			///---Sim 10-23-2008 QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER
			if ( fuIsSysFilter(trNewFilter.FileName.strVal) )
				updateFilterFromSheetTheme(trNewFilter, strWinName);
			///---END QA80-12422 DRAG_AND_DROP_USE_SHEET_THMEM_WHEN_FROM_SYS_FILTER
			///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
			if ( IMPORT_FILES_CHECK_USE_LAST_IMPORT_SETTINGS & dwCntrl )
			{
				TreeNode	trSettings;
				if ( _check_get_last_import_settings(trSettings, strWinName) )
				{
					octree_copy_values_by_id(&trSettings, &trNewFilter, FALSE, NULL, NULL, TRUE, FALSE, TRUE);
				}
			}
			///------ End BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
			if ( trFilter.FileName && trNewFilter.FileName )
			{
				if ( trFilter.FileName.strVal == trNewFilter.FileName.strVal )
					bSameFilter = true;
			}
				
			trFilter = trNewFilter;
		}
	}
	
	return nRet;
}
static void getApplicableFiles(StringArray& saApplicableFiles, StringArray& saResidualFiles, const TreeNode& trFilter)
{
	int nSize = saResidualFiles.GetSize();
	for ( int ii = nSize - 1; ii >= 0; ii-- )
	{
		///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		//if ( IsApplicable(trFilter, saResidualFiles[ii]) )
		if ( is_applicable_ex(trFilter, saResidualFiles[ii]) )
		///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		{
			saApplicableFiles.InsertAt(0, saResidualFiles[ii]);
			saResidualFiles.RemoveAt(ii);
		}
	}
}
/////---END SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE

///Hong 9/26/06 MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION
/*
static int GetFilterClassName(TreeNode& trFilter, string& strClassName)
{
	StringArray	saFilterClassName ={"IWASCII","IWBINARY", "IWUser","IWXF"};
	
	int nFilterType = fuGetType(trFilter);
	if ( nFilterType >= saFilterClassName.GetSize() )
		return IMPERR_FILTER_TYPE;
	strClassName = saFilterClassName[nFilterType];
	return IMPERR_NONE;
}
*/
/// END MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION
///---Sim 09-06-2006 HAVE_IMPLEMENT_IN_FU_UTILS
/*
static Layer GetTargetLayer(Page& pgTarget, int& nIndexLayer, int nIndexFile, TreeNode& trFilter, BOOL bSameFilter)
{
	Layer lyTarget = pgTarget.Layers(nIndexLayer);

	int nPageType = EXIST_NONE;
	if( pgTarget )
		nPageType = pgTarget.GetType();

	int nImportMode = fuGetImportMode(trFilter);
	if( ASCIMP_MODE_AUTO == nImportMode )
	{
		if( fuIsRenameWorkbook(trFilter) )
			nImportMode = ASCIMP_MODE_NEW_BOOKS;
		else if( fuIsRenameWks(trFilter) )
			nImportMode = ASCIMP_MODE_NEW_SHEETS;
		else
			nImportMode = ASCIMP_MODE_REPLACE_DATA;
	}

	if( fuGetTargetPage(trFilter) == nPageType )
	{
		if( ASCIMP_MODE_REPLACE_DATA == nImportMode )
		{
			if ( 0 == nIndexFile)
				return lyTarget;
			nImportMode = ASCIMP_MODE_NEW_BOOKS;
		}
		
		/// import diff type files need use new workbook
		if ( 0 != nIndexFile && !bSameFilter && (ASCIMP_MODE_APPEND_COLS == nImportMode || ASCIMP_MODE_APPEND_ROWS == nImportMode ) )
			nImportMode = ASCIMP_MODE_NEW_BOOKS;
			
		switch( nImportMode )
		{
		case ASCIMP_MODE_APPEND_COLS:
		case ASCIMP_MODE_APPEND_ROWS:
			/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
			///return pgTarget;
			return lyTarget;
			/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
		case ASCIMP_MODE_NEW_BOOKS:
			break;
		case ASCIMP_MODE_NEW_SHEETS:
			// We may want to put first file into active sheet
			// if active sheet is considered empty.
			/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
			if( 0 == nIndexFile && _is_sheet_empty(lyTarget) )
				return lyTarget;
			/// end PRESERVE_ACTIVE_PAGE_AND_LAYER

			nIndexLayer = pgTarget.AddLayer();
			if( nIndexLayer >= 0 )
			/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
			///	page_set_active_layer(pgTarget, nLayer);
			///return pgTarget;
				return pgTarget.Layers(nIndexLayer);
			return NULL;
			/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
		default:
			ASSERT(FALSE); // should never come here
			// TODO: error handle here
			ImportErrorMsgBox(IMPERR_IMPORT_MODE, NULL); ///---Sim 07-31-2006 ERR_HANDLE
			return NULL;
		}
	}
	/// end NEW_IMPORT_MODES

	/// EJP 08-12-2003 v7.0657 HIDE_DATA_WINDOW_ON_IMPORT_INTO_GRAPH
	int iOption = CREATE_VISIBLE;
	if( pgTarget && EXIST_PLOT == pgTarget.GetType() )
		iOption = CREATE_HIDDEN;
	
	// create a new page
	int iType;
	string strTemplate;
	iType = fuGetTargetPage(trFilter, strTemplate);
	
	//Page pgTarget;
	if( EXIST_MATRIX == iType )
	{
		MatrixPage pgMat;
		if( strTemplate.IsEmpty() )
			strTemplate = LabTalk.System.Matrix.DefTemplate$;
		pgMat.Create(strTemplate, iOption);
		pgTarget = pgMat;
	}
	else if( EXIST_WKS == iType )
	{
		WorksheetPage pgWks;
		if( strTemplate.IsEmpty() )
			strTemplate = LabTalk.System.Wks.DefTemplate$;
		pgWks.Create(strTemplate, iOption);
		pgTarget = pgWks;
	}

	nIndexLayer = 0; ///---Sim 07-31-2006 CREATE_PAGE
	return pgTarget.Layers();
	/// end HIDE_DATA_WINDOW_ON_IMPORT_INTO_GRAPH
}
*/
///---END HAVE_IMPLEMENT_IN_FU_UTILS

///---Sim 08-01-2006 NO_NEED_LAYER
//int IWBase::Execute(Layer& lyTarget, int nIndexFile, string& strFileName, TreeNode& tnInfo, TreeNode& trFilter, string& strGraphPage, int nIndexLayer)
///Kyle 10/29/08 MOVE_CODE_FOR_DRAG_AND_DROP_TO_FILE_DRAG_N_DROP
//virtual int IWBase::Execute(Layer& lyTarget, int nIndexFile, string& strFileName, TreeNode& tnInfo, TreeNode& trFilter)
/////---END NO_NEED_LAYER
//{
	//int nRet;
	///// Hong 8/07/06 MOVE_TO_IMPWIZ_H
	////Page pgData;
	////if ( lyTarget )
		////lyTarget.GetParent(pgData);
	///// end MOVE_TO_IMPWIZ_H
	//
	//int nImportMode = fuGetImportMode(trFilter);
	///// Hong 8/07/06 MOVE_TO_IMPWIZ_H
	///// AW 08/03/06 MORE_ON_IW_IMPORT
	////if ( nRet = PrepareWksColsForImport(lyTarget, trFilter) )
		////return nRet;
	////
	////GetWksColInfo(lyTarget);
	///// END MORE_ON_IW_IMPORT
	///// end MOVE_TO_IMPWIZ_H
//
	//if ( nRet = ImportFile(lyTarget, nIndexFile, strFileName, trFilter, tnInfo, nImportMode) )
		//return nRet;
	//
	///// AW 07/31/06 MORE_ON_IW_FILTER
	///*
	//string strWinName = pgData.GetName();
	//GraphPage grpg;
	//grpg = GetTargetGraphPage(trFilter, strWinName, strGraphPage);
	//if( grpg )
	//{
		//int nPlotID = fuGetPlotID(trFilter);
		//if ( nRet = GraphData(grpg, nIndexLayer, nPlotID, pgData) )
			//return nRet;
	//}
	//*/
	///// END MORE_ON_IW_FILTER
	///// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
	/////---Sim 08-02-2006 GET_IMP_INFO_NEED_FILTER
	////if ( nRet =  GenerateImpInfo(strFileName, lyTarget, tnInfo) )
	///// AW 08/03/06 MORE_ON_IW_IMPORT
	////if ( nRet =  GenerateImpInfo(strFileName, lyTarget, trFilter, tnInfo) )
	////	return nRet;
	////SetWksColInfo(pgData);    		/// AW 08/06/06 CHECK_IW_FILTER
	////SetPageLayer(pgData, lyTarget, trFilter, strFileName, tnInfo);//Hong 8/07/06 MOVE_TO_IMPWIZ_H
	///// END MORE_ON_IW_IMPORT
	/////---END GET_IMP_INFO_NEED_FILTER
	///// END ADD_DATA_RANGE_IN_XF_IMPORT_FILE
	//
	///// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
	//AfterImport(lyTarget, strFileName, trFilter, tnInfo);
	///// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
//
	//return IMPERR_NONE;
//}
//
///// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
////virtual
//void	IWBase::AfterImport(const Layer& lyTarget, LPCSTR lpszFileName, const TreeNode& trFilter, TreeNode& tnInfo)
//{
	//string 		strLTScript;
	//if( fuGetPostImportScript(trFilter, strLTScript) && !strLTScript.IsEmpty() )
	//{
		//if ( lyTarget )
			//lyTarget.LT_execute(strLTScript);
	//}
//}
///// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
//
//
//virtual void IWBase::SetDataRange(Page&pgTarget, TreeNode& trImpInfo)
//{
	//TreeNode trNode = trImpInfo.GetNode("DataRange");
	//
	//BOOL bImpInfoHasDataRange;
	//if( trNode.IsValid() )
		//bImpInfoHasDataRange = true;
//
	//// Get the data range for the imported data
	///*
	//if( !bImpInfoHasDataRange  && EXIST_WKS == pgTarget.GetType() && FILTER_TYPE_USERDEFINED != m_iFilterType )
	//{
		//Worksheet wks(pgTarget.GetName());
		//DataRange dr;
		//dr.Add("Import", wks, s_stResult.nR1, s_stResult.nC1, s_stResult.nR2, s_stResult.nC2);
	//
		//Tree trRange;
		//dr.GetTree(trRange);
		//
		//m_trFile.DataRange.Range.strVal = trRange.Import.strVal;
	//}
	//*/
//}
///End MOVE_CODE_FOR_DRAG_AND_DROP_TO_FILE_DRAG_N_DROP
/// Hong 8/07/06 MOVE_TO_IMPWIZ_H
/*
virtual void IWBase::GenerateImpInfo(string& strFileName, Page& pgTarget, TreeNode& trFilter, TreeNode& trImpInfo) 
{
	impinfo_InitTree(pgTarget, fuGetImportMode(trFilter));
	impinfo_GetLastFileNode(pgTarget, m_trFile);
	impinfo_FileInfoToFileNode(m_trFile, strFileName, m_iFilterType);

	TreeNode trNode = trImpInfo.FirstNode;
	while( trNode )
	{
		m_trFile.AddNode(trNode, true);
		trNode = trNode.NextNode;
	}
	
	SetDataRange(pgTarget, trImpInfo);
}

///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
virtual void IWBase::SetColDesignations(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols)
{
		///////////////////////////////////////////////////////
		// The follwoing will construct the designation strings.
		///////////////////////////////////////////////////////
		// Start with the designations in the filter.
		string strColDesig = fuGetDesignations(trFilter);
		bool bRepetitive = fuGetRepetitive(trFilter);
		
		if ( nFirstTargetCol + strColDesig.GetLength() >= wks.GetNumCols() )
		{
			// When the col designation have equal or more cols than the wks
			// just add front of existing settings into current existing setting.
			string strExistColDesig = wks.GetColDesignations();
			strExistColDesig.Delete(nFirstTargetCol, strExistColDesig.GetLength() - nFirstTargetCol);
			strColDesig.Insert(0, strExistColDesig);
		}
		else
		{
			// When the col designation strings have less cols than the wks
			// we need to append the current existing settings to avoid having our
			// last setting repeating and overwriting the existing settings.
			string strTmp = wks.GetColDesignations();
			GetColumnSetting(strTmp, strColDesig, nFirstTargetCol, nCols, bRepetitive);
			strColDesig = strTmp;
		}
		
		m_bRepetitive = bRepetitive;
		m_strColDesig = strColDesig;
		wks.SetColDesignations(strColDesig, bRepetitive);
}

virtual void IWBase::SetColFormats(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols)
{
		///////////////////////////////////////////////////////
		// The follwoing will construct the format strings.
		///////////////////////////////////////////////////////
		// Start with the format in the filter.
		string strColFormat = fuGetFormats(trFilter);
		bool bRepetitive = fuGetRepetitive(trFilter);
		
		if ( nFirstTargetCol + strColFormat.GetLength() >= wks.GetNumCols() )
		{
			// When the col format have equal or more cols than the wks
			// just add front of existing settings into current existing setting.
			string strExistColFormat = wks.GetColFormats();
			strExistColFormat.Delete(nFirstTargetCol, strExistColFormat.GetLength() - nFirstTargetCol);
			strColFormat.Insert(0, strExistColFormat);
		}
		else
		{
			// When the col format strings have less cols than the wks
			// we need to append the current existing settings to avoid having our
			// last setting repeating and overwriting the existing settings.
			string strTmp = wks.GetColFormats();
			GetColumnSetting(strTmp, strColFormat, nFirstTargetCol, nCols, bRepetitive);
			strColFormat = strTmp;
		}
		
		m_bRepetitive = bRepetitive;
		m_strColFormat = strColFormat;
		wks.SetColFormats(strColFormat, bRepetitive);
		
		/// AW 08/06/06 CHECK_IW_FILTER
		string strCustomFormat;
		if( fuGetCustomDate(trFilter, strCustomFormat) )
		{
			Column col;
			int nIndex = strColFormat.Find('3', 0); // column formats - Date	(3)
			while( nIndex >= 0 )
			{
				col = wks.Columns(nIndex);
				if( col )
				{
					Tree tr;
					if( info_get_section(col, tr, "system.display") )
					{
						tr.CustomFormat.strVal = strCustomFormat;
						info_set_section(col, tr, "system.display");
					}
					col.SetSubFormat(LDF_OBJ_CUSTOM);
				}
				nIndex = strColFormat.Find('3', nIndex + 1);
			}
			
		}
		/// END CHECK_IW_FILTER
}
///---END COMMON_FUNC_ON_BASE_CLASS

/// AW 08/03/06 MORE_ON_IW_IMPORT

virtual int IWBase::PrepareWksColsForImport(Layer &lyTarget, TreeNode &trFilter) 
{  
	///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
	Worksheet wks(lyTarget);
	if( !wks )
		/// 08/09/06 AW CHECK_IW_FILTER 
		//return IMPERR_PREPARE_WKS; // error, no worksheet
		return IMPERR_NONE;
		/// END CHECK_IW_FILTER
	
	///////////////////////////////////////////////////////
	// The following (switch on filter type) will set nCols
	// to the number of columns in the data file.
	// This number may not always be correct, but should be
	// sufficient for setting up the wks columns.
	//
	// It may be easier/safer to use the ColDesignations or
	// ColFormats setting in the filter.  I will look into
	// this later.
	///////////////////////////////////////////////////////
	int nCols = GetColNumberFromFilter(trFilter);

	///////////////////////////////////////////////////
	// The following will adjust nCols based on the
	// partial import settings.
	///////////////////////////////////////////////////
	int nFirstSourceCol = 0;
	if( trFilter.Common.Partial.nVal )
	{
		nFirstSourceCol = trFilter.Common.PartialC1.nVal;
		
		if( nFirstSourceCol > trFilter.Common.PartialC2.nVal )
			nCols -= nFirstSourceCol;
		else
			nCols = trFilter.Common.PartialC2.nVal - nFirstSourceCol + 1;
	}
	
	///////////////////////////////////////////////////
	// The following (switch on import mode) will
	// adjust nCols based on the import mode.
	///////////////////////////////////////////////////
	int nFirstTargetCol = 0;
	int nNumExistingCols = wks.GetNumCols();
	int nNewCols = 0;
	switch( fuGetImportMode(trFilter) )
	{
	case ASCIMP_MODE_REPLACE_DATA:
	case ASCIMP_MODE_APPEND_ROWS:
	case ASCIMP_MODE_NEW_BOOKS:
	case ASCIMP_MODE_NEW_SHEETS:
	case ASCIMP_MODE_AUTO:
		if( nCols > nNumExistingCols )
			nNewCols = nCols - nNumExistingCols;
		break;
	case ASCIMP_MODE_APPEND_COLS:
		nFirstTargetCol = wks_find_empty_column(wks);
		 
		if( nFirstTargetCol >= 0 )
		{
			nNewCols = nCols - (nNumExistingCols - nFirstTargetCol);
		}
		else // no empty columns
		{
			nFirstTargetCol = nNumExistingCols;
			nNewCols = nCols;
		}
		break;
	}
	
	string str;
	if( nNewCols > 0 )
	{
		Page pgTarget;
		lyTarget.GetParent(pgTarget);
		str.Format("work -a %d", nNewCols);
		pgTarget.LT_execute(str);
	}

	if( wks.IsWriteProtected(nFirstTargetCol, nFirstTargetCol + nCols) )
	{
		if( IDNO == MessageBox(GetWindow(),
			_L("The data's target window has a locked column.\nDo you want to continue import?"),
			_L("File Import"), MB_YESNO) )
		{
			return IMPERR_CANCEL_ON_LOCKED_COL;
		}
	}
	
	/// AW 08/06/06 CHECK_IW_FILTER
//	SetColDesignations(wks, trFilter, nFirstTargetCol, nCols);
//	SetColFormats(wks, trFilter, nFirstTargetCol, nCols);

	string strColDesig = fuGetDesignations(trFilter);
	string strColFormat = fuGetFormats(trFilter);

	if( nFirstSourceCol )
	{
		strColDesig.Delete(0, nFirstSourceCol);
		strColFormat.Delete(0, nFirstSourceCol);
	}
	
	bool bRepetitive = fuGetRepetitive(trFilter);
		
	if ( nFirstTargetCol + strColDesig.GetLength() >= wks.GetNumCols() )
	{
		// When the col designation have equal or more cols than the wks
		// just add front of existing settings into current existing setting.
		string strExistColDesig = wks.GetColDesignations();
		strExistColDesig.Delete(nFirstTargetCol, strExistColDesig.GetLength() - nFirstTargetCol);
		strColDesig.Insert(0, strExistColDesig);
	}
	else
	{
		// When the col designation strings have less cols than the wks
		// we need to append the current existing settings to avoid having our
		// last setting repeating and overwriting the existing settings.
		string strTmp = wks.GetColDesignations();
		GetColumnSetting(strTmp, strColDesig, nFirstTargetCol, nCols, bRepetitive);
		strColDesig = strTmp;
	}
	
	m_bRepetitive = bRepetitive;
	m_strColDesig = strColDesig;
	wks.SetColDesignations(strColDesig, bRepetitive);
	
	
	if ( nFirstTargetCol + strColFormat.GetLength() >= wks.GetNumCols() )
	{
		// When the col format have equal or more cols than the wks
		// just add front of existing settings into current existing setting.
		string strExistColFormat = wks.GetColFormats();
		strExistColFormat.Delete(nFirstTargetCol, strExistColFormat.GetLength() - nFirstTargetCol);
		strColFormat.Insert(0, strExistColFormat);
	}
	else
	{
		// When the col format strings have less cols than the wks
		// we need to append the current existing settings to avoid having our
		// last setting repeating and overwriting the existing settings.
		string strTmp = wks.GetColFormats();
		GetColumnSetting(strTmp, strColFormat, nFirstTargetCol, nCols, bRepetitive);
		strColFormat = strTmp;
	}
	
	m_bRepetitive = bRepetitive;
	m_strColFormat = strColFormat;
	wks.SetColFormats(strColFormat, bRepetitive);
	
	string strCustomFormat;
	if( fuGetCustomDate(trFilter, strCustomFormat) )
	{
		Column col;
		int nIndex = strColFormat.Find('3', 0); // column formats - Date	(3)
		while( nIndex >= 0 )
		{
			col = wks.Columns(nIndex);
			if( col )
			{
				Tree tr;
				if( info_get_section(col, tr, "system.display") )
				{
					tr.CustomFormat.strVal = strCustomFormat;
					info_set_section(col, tr, "system.display");
				}
				col.SetSubFormat(LDF_OBJ_CUSTOM);
			}
			nIndex = strColFormat.Find('3', nIndex + 1);
		}
		
	}
	/// END CHECK_IW_FILTER

	
	return IMPERR_NONE;
	//return 0; // do nothing for some derived class
	///---END COMMON_FUNC_ON_BASE_CLASS
}
virtual void IWBase::RenameTarget( string& strFullFileName, Layer& lyTarget, Page& pgTarget, TreeNode &trFilter )
{
	string strNewName = GetFileName(strFullFileName, TRUE);
	if( !strNewName.IsEmpty() )
	{
		if( lyTarget && fuIsRenameWks(trFilter) )
			lyTarget.SetName(strNewName);

		if( fuIsRenameWorkbook(trFilter) )
			pgTarget.Rename(strNewName);
	}		
}
virtual void IWBase::SetPageInfo(Page& pgTarget, TreeNode& trFilter, string& strFileName)
{
	okutil_SetPageInfo(pgTarget.GetName(), strFileName, m_iFilterType);	
}
virtual BOOL IWBase::ImportHeaderVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter)
{
	return false;
}
virtual BOOL IWBase::ImportFileNameVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter)
{
	return false;
}

virtual void IWBase::GetWksColInfo(Layer& lyTarget)
{
	Worksheet wks(lyTarget);
	if ( wks )
	{
		m_strColDesig = wks.GetColDesignations();
		m_strColFormat = wks.GetColFormats();
		m_bRepetitive = false; ///---Sim 08-04-2006 RECORD_COL_DESIG_FORMAT_REPETITIVE
	}
}
virtual void IWBase::SetWksColInfo(Page& pgTarget)
{
	Worksheet wks(pgTarget.GetName());
	if ( wks && FILTER_TYPE_USERDEFINED != m_iFilterType)
	{
		string strColDesig = wks.GetColDesignations();  //test
		string strColFormat = wks.GetColFormats();		//test
		
		///---Sim 08-04-2006 RECORD_COL_DESIG_FORMAT_REPETITIVE
		//wks.SetColDesignations(m_strColDesig, false);
		//wks.SetColFormats(m_strColFormat, false);
		wks.SetColDesignations(m_strColDesig, m_bRepetitive);
		wks.SetColFormats(m_strColFormat, m_bRepetitive);
		///---END RECORD_COL_DESIG_FORMAT_REPETITIVE
	}
}

void IWBase::SetPageLayer(Page& pgTarget, Layer& lyTarget, TreeNode &trFilter, string& strFullFileName, TreeNode& trImpInfo)
{
	GenerateImpInfo(strFullFileName, pgTarget, trFilter, trImpInfo);

	RenameTarget(strFullFileName, lyTarget, pgTarget, trFilter);
	
	StringArray saVarNames, saVarValues;
		
	if  ( ImportHeaderVars(saVarNames, saVarValues, strFullFileName, trFilter) )
	{
		impinfo_HeaderVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if( fuIsVarInPageInfo(trFilter) )
			HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);

		// Reset arrays before importing file name variables
		saVarNames.SetSize(0); // Remove header variable names
		saVarValues.SetSize(0); // Remove header variable values
	}

	if ( ImportFileNameVars(saVarNames, saVarValues, strFullFileName, trFilter) )
	{
		impinfo_FileNameVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if( fuIsVarInPageInfo(trFilter) )
			HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);
	}

	if( fuIsAppendFileNameToWorkBookComments(trFilter) )
	{
		string strFileName;
		if( fuIsAppendFileNameWithoutPath(trFilter) )
			strFileName = GetFileName(strFullFileName);
		else
			strFileName = strFullFileName;
		
		string strComments;
		strComments = pgTarget.GetComments();
		if( !strComments.IsEmpty() )
			strComments += "\r\n";
		strComments += strFileName;
		pgTarget.SetComments(strComments);
	}
	
	SetPageInfo(pgTarget, trFilter, strFullFileName);
	
	string strLTScript;
	if( fuGetPostImportScript(trFilter, strLTScript) && !strLTScript.IsEmpty() )
	{
		Layer lay = pgTarget.Layers();
		if( lay )
			lay.LT_execute(strLTScript);
	}
	
	bool bOK = impinfo_SetLastFileNode(pgTarget, m_trFile);
	
	/// testing
	Tree trTemp;
	bOK = impinfo_GetLastFileNode(pgTarget, trTemp);

	ASSERT(bOK);
}

//MORE_ON_IW_IMPORT
*/ 
/// end MOVE_TO_IMPWIZ_H

///---Sim 01-25-2007 MORE_UTILS_FUNCTION
static bool isSameExtension(const string& strFile1, const string& strFile2)
{
	string strExt1, strExt2;
	separate_file_name_ext(strFile1, NULL, &strExt1);
	separate_file_name_ext(strFile2, NULL, &strExt2);
	strExt1.MakeLower();
	strExt2.MakeLower();	
	return (strExt1 == strExt2);
}
static string _str_combine(vector<string> vsSource, int nIndex, int nLen, LPCSTR lcpszSep)
{
	string strDest;
	if ( nLen <= 0 )
		return strDest;
	
	string strSep(lcpszSep);
	strDest = vsSource[nIndex];
	for (int ii = 1; ii < nLen; ii++) // start from second item of string array
	{
		strDest = strDest + strSep + vsSource[nIndex+ii];
	}
	return strDest;
}
///---END MORE_UTILS_FUNCTION

///---Sim 01-24-2007 SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE
/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//static int importFile(IWBase& iwFilter, Layer& lyTarget, int nIndexFile, string strFileName,
//			 TreeNode& trImpInfo, TreeNode& trFilter, string& strGraphPage, BOOL bSameFilter)
static int importFile(IWBase& iwFilter, Layer& lyTarget, int nIndexFile, string strFileName,
			 TreeNode& trImpInfo, TreeNode& trFilter, string& strGraphPage, BOOL bSameFilter, DWORD dwCntrl = 0)
/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
{
	int nRet;
	//import data file
	if ( nRet = iwFilter.Execute(lyTarget, nIndexFile, strFileName, trImpInfo, trFilter) )			
	{
		//ToDO:error handle
		///---Sim 09-11-2007 FIX_SHOW_ERROR_MESSAGE_WHEN_FILTER_INCORRECT
		//ImportErrorMsgBox(IMPERR_IMPORT_FUNC_ERR, NULL); ///---Sim 07-31-2006 ERR_HANDLE
		LPCSTR lpcszFilterName = NULL;
		if ( trFilter.FileName )
			lpcszFilterName = trFilter.FileName.strVal;
		ImportErrorMsgBox(IMPERR_IMPORT_FUNC_ERR, lpcszFilterName);
		///---END FIX_SHOW_ERROR_MESSAGE_WHEN_FILTER_INCORRECT
		return nRet;			
	}
	/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
	//GraphLayer lyGraph = GetTargetGraphLayer(trFilter, strGraphPage, bSameFilter );
	GraphLayer lyGraph = GetTargetGraphLayer(trFilter, strGraphPage, bSameFilter, IMPORT_FILES_DRAG_N_DROP_TO_WORKSPACE & dwCntrl);
	/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
	if ( lyGraph )
	{
		int nPlotID = fuGetPlotID(trFilter);
		if ( nRet = GraphData(lyGraph, nPlotID, iwFilter.GetDatRange()) )
			return nRet;	
	}
}
///---END SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE

//// AW 09/26/06 MORE_ON_ADD_IMPFILE_XF
/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource)
///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes) //  NULL, NULL
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL ImportFiles(StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes, DWORD dwCntrl/* = 0*/) //  NULL, NULL
///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
//BOOL import_files_ex(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes, DWORD dwCntrl/* = 0*/) //  NULL, NULL
BOOL import_files_ex(const StringArray& stDataFileName, LPCSTR strPageName, int nIndexLayer, TreeNode& trFilterSource, LPCSTR lpcszTypes, DWORD dwCntrl/* = 0*/, TreeNode* ptrFilterLastUsed/* = NULL*/) //  NULL, NULL
///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
{
	///---Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	FUNC_IMPORTFILES fImportFiles;
	fImportFiles = Project.FindFunction(IMPORT_FUNC_NAME_IMPORT_FILES, IMPORT_FUNC_PATH, true);
	ASSERT(fImportFiles);	
	///---END QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	
	//StringArray stNoFilterFiles; ///---Sim 01-05-2006 SUPPORT_NO_FILTER
	Tree trFilterList;
	int nRet;
	//string strFullFileName;
	int nNumFiles = stDataFileName.GetSize();
	if ( trFilterSource && trFilterSource.GetNodeCount()>0 )
	{
		
		for (int ii = 0; ii < nNumFiles; ii++ )
		{
			///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
			if ( !O_QUERY_BOOL(dwCntrl, IMPORT_FILES_NO_FILTER_APPLICABLE_CHECKING) )
			///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
			{
				/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
				//if ( !IsApplicable(trFilterSource, stDataFileName[ii] ) )	
				///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
				//if ( !IsApplicable(trFilterSource, stDataFileName[ii], lpcszTypes) )	
				if ( !is_applicable_ex(trFilterSource, stDataFileName[ii], lpcszTypes) )	
				///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
				/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
				{
					out_str("Wrong provided filter"); // better error handle needed here
					return false;
				}
			}
			trFilterSource.SetAttribute("nID", 1);
			trFilterList.AddNode(trFilterSource);
		}
	}
	///---Sim 01-24-2007 SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE
	/*
	///---Sim 01-05-2006 SUPPORT_NO_FILTER
	//else if (nRet = GetFilters( stDataFileName, trFilterList, strPageName) )
	/// Hong 01/17/07 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
	//else if (nRet = GetFilters( stDataFileName, stNoFilterFiles, trFilterList, strPageName) )
	else if (nRet = GetFilters( stDataFileName, stNoFilterFiles, trFilterList, strPageName, lpcszTypes) )
	/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
	///---Sim 01-05-2006 SUPPORT_NO_FILTER
	{
		///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		//if ( IMP_IMPWIZ == nRet )
		//{
			//// check current active page
			//Page pgTarget(strPageName);
			//if ( !pgTarget )
			//{
				//WorksheetPage wp;
				//wp.Create("Origin"); // temp code, not have any factor to decide which page type should be created.
			//}
			//
			//string strFileNames = str_combine(stDataFileName, "\r\n");
			//ImportWizard(strFileNames);
			//return true;
		//}
		///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
		
		if ( IMP_USER_CANCEL == nRet )
			return true;
		// TODO: error handle here needed
		ImportErrorMsgBox(nRet, NULL); ///---Sim 07-31-2006 ERR_HANDLE
		return false;
	}
	*/
	
	//import each data file
	/*
	nNumFiles = stDataFileName.GetSize(); ///---Sim 01-05-2006 SUPPORT_NO_FILTER
	ASSERT(nNumFiles == trFilterList.GetNodeCount() );
	int nIndexFile = -1; 
	/// AW 07/31/06 MORE_ON_IW_FILTER
	//string strClassName, strGraphPage;
	string strClassName, strGraphPage = strPageName;
	/// END MORE_ON_IW_FILTER
	Page pgTarget(strPageName);
	Layer lyTarget;
	Tree trImpInfo;
	int nID, nPreID = -1;
	BOOL bSameFilter;
	nNumFiles--;
	foreach( TreeNode trFilter in trFilterList.Children)
	{
		// get right layer
		trFilter.GetAttribute("nID",nID);
		bSameFilter = nPreID == nID? true : false;
		/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
		//
		//lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nIndexFile, trFilter, bSameFilter);
		//nPreID = nID;
		//// get right IWClass
		//if ( nRet = GetFilterClassName(trFilter, strClassName) )
		//{
			//// TODO: error handle
			//ImportErrorMsgBox(IMPERR_IWCLASS_UNDEFINED,	strClassName); ///---Sim 07-31-2006 ERR_HANDLE
			//return false;			
		//}
		//IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
		//
		/// Hong 9/08/06 CONVERT_ORIGIN75_FILTER_T0_80
		//if(trFilter.OriginVersion.dVal < 8.0473)
		if(fuGetOriginVersion(trFilter) < 8.0473)/// Hong 9/12/06 GET_FILTER_BY_ID
		{
			Tree trNode;
			ConvFilter(trFilter, trNode);
			///---Sim 09-15-2006 STAY_FILTER_FILE_NAME
			if ( trFilter.FileName )
				trNode.AddNode(trFilter.FileName);
			///---END STAY_FILTER_FILE_NAME
			trFilter.Replace(trNode.Clone());
		}
		/// end CONVERT_ORIGIN75_FILTER_T0_80
		nPreID = nID;
		if ( !bSameFilter)
		{
			if ( nRet = GetFilterClassName(trFilter, strClassName) )
			{
				// TODO: error handle
				ImportErrorMsgBox(IMPERR_IWCLASS_UNDEFINED,	strClassName); ///---Sim 07-31-2006 ERR_HANDLE
				return false;			
			}
		}
		nIndexFile++;
		IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
		if ( 0 == nIndexFile )
			iwFilter.InitFileArray();
		if ( strClassName != "IWXF" || !bSameFilter )
			lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nIndexFile, trFilter, bSameFilter);
		/// Hong 9/12/06 FIX_NOT_ADD_CORRECT_FILENAME
		//if (  iwFilter.AddFile(strFullFileName, bSameFilter ) && nNumFiles != nIndexFile )
		if (  iwFilter.AddFile(stDataFileName[nIndexFile], bSameFilter ) && nNumFiles != nIndexFile )
		/// end FIX_NOT_ADD_CORRECT_FILENAME
			continue;
		/// END SUPPORT_MULTI_FILES_INXF
		
		//import data file
		strFullFileName = stDataFileName[nIndexFile];
		///---Sim 08-01-2006 NO_NEED_LAYER_NUM
		//if ( nRet = iwFilter.Execute(lyTarget, nIndexFile, strFullFileName, trImpInfo, trFilter, strGraphPage, nIndexLayer) )
		if ( nRet = iwFilter.Execute(lyTarget, nIndexFile, strFullFileName, trImpInfo, trFilter) )			
		///---END NO_NEED_LAYER_NUM
		{
			//ToDO:error handle
			ImportErrorMsgBox(IMPERR_IMPORT_FUNC_ERR, NULL); ///---Sim 07-31-2006 ERR_HANDLE
			return false;			
		}
		/// AW 07/31/06 MORE_ON_IW_FILTER
		GraphLayer lyGraph = GetTargetGraphLayer(trFilter, strGraphPage, bSameFilter );
		if ( lyGraph )
		{
			int nPlotID = fuGetPlotID(trFilter);
			/// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
			//if ( nRet = GraphData(lyGraph, nPlotID, lyTarget) )
			if ( nRet = GraphData(lyGraph, nPlotID, iwFilter.GetDatRange()) )
			/// END ADD_DATA_RANGE_IN_XF_IMPORT_FILE
				return nRet;	
		}
		/// END MORE_ON_IW_FILTER

	}
	*/

	// preprocess files list, arrange them to file group by extension
	//vector<int> vFileGroupPos;
	//vector<int> vFileGroupLen;
	//int nGroupSize = 0;
	//nNumFiles = stDataFileName.GetSize();
	//for (int ii = 0; ii < nNumFiles; ii++ )
	//{
		//if ( 0 == ii || !isSameExtension(stDataFileName[ii-1], stDataFileName[ii]) )
		//{	// new group type
			//vFileGroupPos.Add(ii);
			//vFileGroupLen.Add(1);
			//nGroupSize++;
		//}
		//else
		//{	// same group
			//vFileGroupLen[nGroupSize-1]++;
		//}
	//}
	StringArray saResidualFiles;
	saResidualFiles = stDataFileName;
	
	string strClassName, strGraphPage = strPageName;
	Page pgTarget(strPageName);
	Layer lyTarget;
	if ( pgTarget )
		lyTarget = pgTarget.Layers();
	
	Tree trImpInfo;
	FUNC_IW_GET_FILTER pfn;	// importwizard function pointer
	Tree trFilter;
	/// Hong 02/16/07 FIX_IMPFILE_FAIL_WORKS_CORRECTLY
	// this maybe temp fix, the logical the been change by Sim which is not correct, need more works to fix it
	bool bFirstFile = true; // use this to avoid some opration on first file
	if(trFilterList && trFilterList.GetNodeCount() > 0)
		trFilter = trFilterList.FirstNode; 
	/// end FIX_IMPFILE_FAIL_WORKS_CORRECTLY
	BOOL bUseSameFilter = true; // whether try to use same filter for next file
	//string strLastFileName;

	//for (int nIndexFile = 0; nIndexFile < nNumFiles; nIndexFile++ )
	//for (int nIndexGroup = 0; nIndexGroup < nGroupSize; nIndexGroup++ )
	while ( saResidualFiles.GetSize() > 0 )
	{
		//int nIndexFile = vFileGroupPos[nIndexGroup];
		//int nLenFiles = vFileGroupLen[nIndexGroup];
		
		// get filter
		string strWinName;
		if ( pgTarget )
			strWinName = pgTarget.GetName();
		//BOOL bSameExtension = isSameExtension(strLastFileName, stDataFileName[nIndexFile]);
		BOOL bIsSameFilter;
		///------ Folger 05/05/09 QA80-4588 BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT
		//nRet = GetOneFilters(trFilter, saResidualFiles[0], strWinName, bUseSameFilter, bIsSameFilter, lpcszTypes);
		/// Hong 09/04/09 QA80-14266 SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		//nRet = GetOneFilters(trFilter, saResidualFiles[0], strWinName, bUseSameFilter, bIsSameFilter, lpcszTypes, IMPORT_FILES_IGNORE_DRAG_AND_DROP_SUPPORT & dwCntrl);
		nRet = GetOneFilters(trFilter, saResidualFiles[0], strWinName, bUseSameFilter, bIsSameFilter, lpcszTypes, dwCntrl);
		/// end SELECT_FILTER_DLG_ADD_NEW_OPTIONS_FOR_BATCH_PROCESSING
		///------ End BATCH_PROCESS_NEED_TO_IGNORE_DRAG_AND_GROP_SUPPORT

		if ( IMP_USER_CANCEL == nRet )
		{
			trFilter.Reset();		///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
			break; // exit import files
		}
		else
		if ( IMPERR_NO_FILTER == nRet )
		{
			saResidualFiles.RemoveAt(0); // skip this file
		}
		else
		if ( IMP_IMPWIZ == nRet )
		{	// no filter for this file
			// check current active page
			bool bEmptyPage = (pgTarget && 1 == pgTarget.Layers.Count() && is_sheet_empty(pgTarget.Layers(0)));
			if ( !bEmptyPage )
			{
				WorksheetPage wp;
				wp.Create("Origin"); // temp code, not have any factor to decide which page type should be created.
				pgTarget = wp;
			}
			
			// load import wizard function
			if ( !pfn )
			{
				LT_execute("run.LoadOC(OriginLab\ImportWiz.ocw);");
				pfn = Project.FindFunction("iwGetFilter", "originlab\\ImportWizard.cpp", TRUE);
			}

			// run import wizard function
			if ( pfn )
			{
				//string strFileNames = _str_combine(stDataFileName, nIndexFile, nLenFiles, "\r\n");
				string strFileName = saResidualFiles[0];
				saResidualFiles.RemoveAt(0);
				
				string strFilterName;
				pfn(strFileName, strFilterName, trFilter);
				nIndexLayer++;
				
				if ( trFilter.GetNodeCount() > 0 )	// valid filter
					trFilter.FileName.strVal = strFilterName;
			}
		}
		else
		{
			if(fuGetOriginVersion(trFilter) < 8.0473)
			{
				Tree trNode;
				ConvFilter(trFilter, trNode);
				if ( trFilter.FileName )
					trNode.AddNode(trFilter.FileName);
				trFilter.Replace(trNode.Clone());
			}
			
			StringArray saApplicableFiles;
			///---Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
			//if (bUseSameFilter)
			bool bMultiFiles = true;
			if ( FILTER_TYPE_XFUNC == fuGetType(trFilter) )
			{
				string strXFName;
				fuGetXFunctionName(trFilter, strXFName);

				if ( !isMultiFilesXF(strXFName) )
					bMultiFiles = false;
			}
			///------ Folger 11/18/09 FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
			if ( IMPERR_FORCE_ASCII_FILTER == nRet || O_QUERY_BOOL(dwCntrl, IMPORT_FILES_NO_FILTER_APPLICABLE_CHECKING) )
			{
				saApplicableFiles = saResidualFiles;
				saResidualFiles.RemoveAll();
			}
			else
			///------ End FORCE_USING_ASCII_IF_NO_APPICABLE_FILTER_FOUND_FOR_BATCH_PROCESS
			if ( bUseSameFilter && bMultiFiles )
			///---END FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
				getApplicableFiles(saApplicableFiles, saResidualFiles, trFilter);
			else
			{	// filter just for current one file
				saApplicableFiles.Add(saResidualFiles[0]);
				saResidualFiles.RemoveAt(0);			
			}
			int nLenFiles = saApplicableFiles.GetSize();
			
			if ( nRet = GetFilterClassName(trFilter, strClassName) )
			{
				// TODO: error handle
				ImportErrorMsgBox(IMPERR_IWCLASS_UNDEFINED,	strClassName);
				return false;			
			}

			//BOOL bSameFilter = false; // different file group shall are different file type
			
			bool bNewPage = false;
			int nFileIndexOffset = 0;
			// prepare target layer
			///---Sim 06-07-2007 FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
			//if ( bIsSameFilter )
			if ( bIsSameFilter && bMultiFiles )
			///---END FIX_D&D_XF_TYPE_NOT_SUPPORT_MULTI_FILES
			{
				/// Hong 02/16/07 FIX_IMPFILE_FAIL_WORKS_CORRECTLY
				// this maybe temp fix, the logical the been change by Sim which is not correct, need more works to fix it
				//nFileIndexOffset = 1;
				if(bFirstFile) 
					nFileIndexOffset = 0;
				else
					nFileIndexOffset = 1;
				/// end FIX_IMPFILE_FAIL_WORKS_CORRECTLY
			}
			else // new filter
			{	// create new book for new file type
				///---Sim 02-13-2007 FIX_REDUNDANT_BOOK_CREATED_BY_TEMPLATE_FILE
				string strTemplate;
				fuGetTargetPage(trFilter, strTemplate);
				///---Sim 06-06-2007 IMPORT_MODE_IS_CHANGED_TO_1ST_IMPORT_MODE
				//int nImportMode = fuGetImportMode(trFilter);
				int nImportMode = fuGet1stImportMode(trFilter);
				///---END IMPORT_MODE_IS_CHANGED_TO_1ST_IMPORT_MODE
				
				// if not valid template for book, create new book to seperate each file type
				bool bHasTemplate = ( !strTemplate.IsEmpty() && (ASCIMP_MODE_NEW_BOOKS == nImportMode) );// || ASCIMP_MODE_NEW_SHEETS == nImportMode);
				/// Hong 02/16/07 FIX_IMPFILE_FAIL_WORKS_CORRECTLY
				// no need do seperate for first import file
				//if ( !bHasTemplate ) 
				if ( !bHasTemplate && !bFirstFile ) 
				/// end FIX_IMPFILE_FAIL_WORKS_CORRECTLY
				{	
					Layer lyOlder = lyTarget;
					///---Sim 06-06-2007 IMPORT_MODE_IS_CHANGED_TO_1ST_IMPORT_MODE
					//fuSetImportMode(trFilter, ASCIMP_MODE_NEW_BOOKS); 
					//lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nFileIndexOffset, trFilter, bIsSameFilter);
					//fuSetImportMode(trFilter, nImportMode);
					fuSet1stImportMode(trFilter, ASCIMP_MODE_NEW_BOOKS); 
					lyTarget = GetTargetLayer(pgTarget, nIndexLayer, 0, trFilter, false);
					fuSet1stImportMode(trFilter, nImportMode);
					///---END IMPORT_MODE_IS_CHANGED_TO_1ST_IMPORT_MODE
					
					bNewPage = bNewPage || !is_same_layer(lyOlder, lyTarget);
				}
				else // has template file
				{
					// imp function will alway new book when filter has template, if that, no need handle here
				}
				///---END FIX_REDUNDANT_BOOK_CREATED_BY_TEMPLATE_FILE
			}
			
			/// Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED
			//IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
			IWBase& iwFilter = (IWBase&) Project.CreateClass(strClassName);
			/// end CLEARLY_NEW_OBJECT_NEEDED
			if ( "IWXF" == strClassName )
			{
				// prepare file names for import class
				iwFilter.InitFileArray();
				for ( int ii = 0; ii < nLenFiles; ii++ )
					iwFilter.AddFile(saApplicableFiles[ii]);
				
				///---Sim 02-13-2007 FIX_REDUNDANT_BOOK_CREATED_BY_TEMPLATE_FILE
				// disable template
				int nType;
				string strTemplate;
				nType = fuGetTargetPage(trFilter, strTemplate);
				fuSetTargetPage(trFilter, nType, "");
				
				// prepare page without template for xf, it must ensure data range is not invalid.
				Layer lyOlder = lyTarget;
				lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nFileIndexOffset, trFilter, bIsSameFilter);
				bNewPage = bNewPage || !is_same_layer(lyOlder, lyTarget);
				
				// enable template
				fuSetTargetPage(trFilter, nType, strTemplate);
				/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
				//nRet = importFile(iwFilter, lyTarget, nFileIndexOffset, "", trImpInfo, trFilter, strGraphPage, bIsSameFilter);
				nRet = importFile(iwFilter, lyTarget, nFileIndexOffset, "", trImpInfo, trFilter, strGraphPage, bIsSameFilter, dwCntrl);
				/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
				bool bEmptyPage = (pgTarget && 1 == pgTarget.Layers.Count() && is_sheet_empty(pgTarget.Layers(0)));
				if ( bNewPage && bEmptyPage )
				{
					pgTarget.Destroy();
					pgTarget = Project.Pages();
				}
				///---END FIX_REDUNDANT_BOOK_CREATED_BY_TEMPLATE_FILE
				if ( nRet )
					return false;				
			}
			else
			{
				for ( int ii = 0; ii < nLenFiles; ii++ )
				{
					///---Sim 05-25-2007 FIX_D&D_MULTI_ASC_FILE_IMPORT_MODE
					bool bSameFilter = ( ii > 0 );
					//lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nFileIndexOffset + ii, trFilter, bIsSameFilter);
					//nRet = importFile(iwFilter, lyTarget, nFileIndexOffset + ii, saApplicableFiles[ii], trImpInfo, trFilter, strGraphPage, bIsSameFilter);
					lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nFileIndexOffset + ii, trFilter, bSameFilter);
					/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
					//nRet = importFile(iwFilter, lyTarget, nFileIndexOffset + ii, saApplicableFiles[ii], trImpInfo, trFilter, strGraphPage, bSameFilter);
					nRet = importFile(iwFilter, lyTarget, nFileIndexOffset + ii, saApplicableFiles[ii], trImpInfo, trFilter, strGraphPage, bSameFilter, dwCntrl);
					/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
					///---END FIX_D&D_MULTI_ASC_FILE_IMPORT_MODE
					if ( nRet )
						return false;
				}
			}
			
			///------ Folger 09/11/09 BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT
			if ( (0 == nLenFiles) && (IMPORT_FILES_CHECK_USE_LAST_IMPORT_SETTINGS & dwCntrl) )
			{
				/// need to remove this bit if not any applicable file been imported, otherwise will cause infinite loop
				dwCntrl &= ~IMPORT_FILES_CHECK_USE_LAST_IMPORT_SETTINGS;
			}
			else
			///------ End BATCH_PROCESS_SUPPORT_GET_FILTER_INFO_FROM_LAST_IMPORT			
			bFirstFile = false; // Hong 02/16/07 FIX_IMPFILE_FAIL_WORKS_CORRECTLY Sim 06-07-2007 move here
		}	
	}
	///---END SELECT_FILTER_AND_IMPORT_FILE_ONE_BY_ONE
	
	///---Sim 01-04-2007 SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP
	/*	
	if ( stNoFilterFiles.GetSize() > 0 )
	{
		string strFileNames = str_combine(stNoFilterFiles, "\n");
		strFileNames.Format("No matched filters are found. Do you want to use Import Wizard to Import them?\n%s", strFileNames);
		int nRet = MessageBox(GetWindow(), strFileNames, "Question", MB_OK|MB_OKCANCEL|MB_ICONQUESTION);
		if ( IDOK == nRet )
		{
			// check current active page
			bool bEmptyPage = (pgTarget && 1 == pgTarget.Layers.Count() && is_sheet_empty(pgTarget.Layers(0)));
			if ( !bEmptyPage )
			{
				WorksheetPage wp;
				wp.Create("Origin"); // temp code, not have any factor to decide which page type should be created.
			}
			
			strFileNames = str_combine(stNoFilterFiles, "\r\n");
			
			LT_execute("run.LoadOC(OriginLab\ImportWiz.ocw);");
			FUNC_STR pfn = Project.FindFunction("ImportWizardWithFileName", "originlab\\ImportWizard.cpp", TRUE);
			if ( pfn )
				pfn(strFileNames);
		}
	}
	*/
	///---END SUPPORT_OPEN_IMPORT_WIZARD_WHEN_DRAG_AND_DROP

	///------ Folger 09/10/09 BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE
	if ( ptrFilterLastUsed )
		*ptrFilterLastUsed = trFilter.Clone();
	///------ End BATCH_PROCESS_SHOULD_POPUP_FILTER_SELECTION_DIALOG_AT_MOST_ONCE

	return true;	
}

///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL LoadFilter(string& strFilterName, String& strDatFile, string& strPageName, int location, TreeNode& trFilter)
BOOL load_import_filter_ex(LPCSTR lpcszFilterName, LPCSTR lpcszDatFile, LPCSTR lpcszPageName, int nLocation, TreeNode& trFilter)
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
{
	///---Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	FUNC_LOADFILTER fLoadFilter;
	fLoadFilter = Project.FindFunction(IMPORT_FUNC_NAME_LOAD_FILTER, IMPORT_FUNC_PATH, true);
	ASSERT(fLoadFilter);	
	///---END QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	string strFilterName = lpcszFilterName;
	string strDatFile = lpcszDatFile;
	string strPageName = lpcszPageName;
	int location = nLocation;
	
	add_file_extension(strFilterName, IMPORT_FILTER_EXTENSION);
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	
	/// Hong 03/21/07 SUPPORT_FULL_PATH_FOR_LOAD_FILTER
	string strTempPath = GetFilePath(strFilterName);
	if( strTempPath.IsPath() && strFilterName.IsFile() )
		location = 4; // full path case
	/// end SUPPORT_FULL_PATH_FOR_LOAD_FILTER
	string strFilePath, strFiler;
	switch (location)
	{
	//.....	get trFilter
	case 0:		// Data file folder
		strFilePath = GetFilePath(strDatFile);
		strFilterName = strFilePath + strFilterName;
		break;
	case 1:		// Origin working filter folder
		strFilePath.Format("%s%s", GetAppPath(TRUE), FILTERS_FOLDER_NAME);
		strFilterName = strFilePath + strFilterName;
		break;
	case 2:		// User filter folder
		strFilePath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
		strFilterName = strFilePath + strFilterName;
		break;
	/*	in this case, no need filtername to be valid	
	case 3:		// In target Page
		Tree trFilterList;
		string strFileName = GetFileName(strDatFile);
		
		StringArray saFilters;	/// AW 07/20/06 USING_IW_FILTER_C 
		
		int nSelected = 0;   	////  AW 08/23/06 ADD_FILTER_FILENAME
		
		// first check filter in page, if find applicable filter no need check folders
		if ( GetFilterFromPage(strPageName, strFileName, saFilters, trFilterList) > 0 )
		{
			trFilter = 	trFilterList.GetNode(STR_FILTER_TYPE_XFUNC);
			if ( trFilter.IsValid() )
				return true;
		}
	*/	
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	case 3:		// In target Page
		Tree trFilterList;
		string strFileName = GetFileName(strDatFile);
		StringArray saFilters;
		
		// first check filter in page, if find applicable filter no need check folders
		if ( GetFilterFromPage(strPageName, strFileName, saFilters, trFilterList) > 0 )
		{
			trFilter.Replace(trFilterList.FirstNode);
			if ( trFilter.IsValid() )
				return true;
		}
		return false;
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	/// Hong 03/21/07 SUPPORT_FULL_PATH_FOR_LOAD_FILTER
	case 4:		// full path case, do nothing to strFilterName
		break;
	/// end SUPPORT_FULL_PATH_FOR_LOAD_FILTER
	default:
		return false;
	}
	if(strFilterName.IsFile())
	{
		fuLoad(trFilter, strFilterName);
		///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		//if ( IsApplicable(trFilter, strDatFile ) )
		if ( is_applicable_ex(trFilter, strDatFile ) )
		///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
			return true;
	}
	return false;
}

///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
// Olive can't find any LT ogs use this function anywhere
// So just comment it out, and test all import features
/*
// maybe LT use this function
BOOL LoadFilter(string& strFilterName, String& strDatFile, string& strPageName, int location, TreeNode& trFilter)
{
	return load_import_filter_ex(strFilterName, strDatFile, strPageName, location, trFilter);
}
*/
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//// END MORE_ON_ADD_IMPFILE_XF


/// Hong 01/17/07 QA80-9250 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
/// Kenny 11/10/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
////BOOL HandleDataFiles()
//BOOL HandleDataFiles(string strTypes)
///// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//{
//	LPCSTR lpcszTypes = NULL;
//	if(!strTypes.IsEmpty())
//	{
//		int nC1 = strTypes.Find('(');
//		int nC2 = strTypes.Find(')');
//		lpcszTypes = strTypes.Mid( nC1 + 1,nC2 - nC1 - 1);
//	}
//	// get the name of all data files
//	string strPageName, strFullFileName;
//	int nRet, nIndexLayer, nIndexFile, nNumFiles;
//	static StringArray 	stDataFileName;	
//	Project.GetDragDropInfo(strPageName, nIndexLayer, nIndexFile, nNumFiles, strFullFileName);
//	if ( 0 == nIndexFile )
//		stDataFileName.SetSize(0);
//	stDataFileName.Add(strFullFileName);
//	if ( nIndexFile < nNumFiles - 1  )
//		return true;
//	ASSERT(nNumFiles == stDataFileName.GetSize());
//	
//	/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//	DWORD		dwCntrl = strPageName.IsEmpty() ? IMPORT_FILES_DRAG_N_DROP_TO_WORKSPACE : 0;
//	/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//	//// AW 09/26/06 MORE_ON_ADD_IMPFILE_XF
//	/// Hong 01/17/07 QA80-9250 FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
//	//return ImportFiles(stDataFileName, strPageName, nIndexLayer);	
//	/// Hong 01/16/08 v8.0786c FIX_STATIC_OBJ_NOT_CORRECT_RESET_WHEN_DEAL_WITH_EXCEL
//	//return ImportFiles(stDataFileName, strPageName, nIndexLayer, NULL, lpcszTypes);
//	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//	//BOOL bRet = ImportFiles(stDataFileName, strPageName, nIndexLayer, NULL, lpcszTypes);
//	/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//	//BOOL bRet = import_files_ex(stDataFileName, strPageName, nIndexLayer, NULL, lpcszTypes);
//	BOOL bRet = import_files_ex(stDataFileName, strPageName, nIndexLayer, NULL, lpcszTypes, dwCntrl);
//	/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
//	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//	stDataFileName.SetSize(0); // clean up after import
//	return bRet;
//	/// end FIX_STATIC_OBJ_NOT_CORRECT_RESET_WHEN_DEAL_WITH_EXCEL
//	/// end FIX_USE_OPEN_FAIL_GET_CORRECT_FILTER
///*	
//	// get all filter  
//	Tree trFilterList;
//	if (nRet = GetFilters( stDataFileName, trFilterList, strPageName) )
//	{
//		if ( IMP_USER_CANCEL == nRet )
//			return true;
//		// TODO: error handle here needed
//		ImportErrorMsgBox(IMP_USER_CANCEL, NULL); ///---Sim 07-31-2006 ERR_HANDLE
//		return false;
//	}
//	
//	// import each data file
//	ASSERT(nNumFiles == stDataFileName.GetSize() );
//	ASSERT(nNumFiles == trFilterList.GetNodeCount() );
//	nIndexFile = -1; 
//	/// AW 07/31/06 MORE_ON_IW_FILTER
//	//string strClassName, strGraphPage;
//	string strClassName, strGraphPage = strPageName;
//	/// END MORE_ON_IW_FILTER
//	Page pgTarget(strPageName);
//	Layer lyTarget;
//	Tree trImpInfo;
//	int nID, nPreID = -1;
//	BOOL bSameFilter;
//	nNumFiles--;
//	foreach( TreeNode trFilter in trFilterList.Children)
//	{
//		// get right layer
//		trFilter.GetAttribute("nID",nID);
//		bSameFilter = nPreID == nID? true : false;
//		/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
//		/*
//		lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nIndexFile, trFilter, bSameFilter);
//		nPreID = nID;
//		// get right IWClass
//		if ( nRet = GetFilterClassName(trFilter, strClassName) )
//		{
//			// TODO: error handle
//			ImportErrorMsgBox(IMPERR_IWCLASS_UNDEFINED,	strClassName); ///---Sim 07-31-2006 ERR_HANDLE
//			return false;			
//		}
//		IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
//		*/
//		/// Hong 9/08/06 CONVERT_ORIGIN75_FILTER_T0_80
//		//if(trFilter.OriginVersion.dVal < 8.0473)
///*		if(fuGetOriginVersion(trFilter) < 8.0473)/// Hong 9/12/06 GET_FILTER_BY_ID
//		{
//			Tree trNode;
//			ConvFilter(trFilter, trNode);
//			///---Sim 09-15-2006 STAY_FILTER_FILE_NAME
//			if ( trFilter.FileName )
//				trNode.AddNode(trFilter.FileName);
//			///---END STAY_FILTER_FILE_NAME
//			trFilter.Replace(trNode.Clone());
//		}
//		/// end CONVERT_ORIGIN75_FILTER_T0_80
//		nPreID = nID;
//		if ( !bSameFilter)
//		{
//			if ( nRet = GetFilterClassName(trFilter, strClassName) )
//			{
//				// TODO: error handle
//				ImportErrorMsgBox(IMPERR_IWCLASS_UNDEFINED,	strClassName); ///---Sim 07-31-2006 ERR_HANDLE
//				return false;			
//			}
//		}
//		nIndexFile++;
//		IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
//		if ( 0 == nIndexFile )
//			iwFilter.InitFileArray();
//		if ( strClassName != "IWXF" || !bSameFilter )
//			lyTarget = GetTargetLayer(pgTarget, nIndexLayer, nIndexFile, trFilter, bSameFilter);
//		/// Hong 9/12/06 FIX_NOT_ADD_CORRECT_FILENAME
//		//if (  iwFilter.AddFile(strFullFileName, bSameFilter ) && nNumFiles != nIndexFile )
//		if (  iwFilter.AddFile(stDataFileName[nIndexFile], bSameFilter ) && nNumFiles != nIndexFile )
//		/// end FIX_NOT_ADD_CORRECT_FILENAME
//			continue;
//		/// END SUPPORT_MULTI_FILES_INXF
//		
//		//import data file
//		strFullFileName = stDataFileName[nIndexFile];
//		///---Sim 08-01-2006 NO_NEED_LAYER_NUM
//		//if ( nRet = iwFilter.Execute(lyTarget, nIndexFile, strFullFileName, trImpInfo, trFilter, strGraphPage, nIndexLayer) )
//		if ( nRet = iwFilter.Execute(lyTarget, nIndexFile, strFullFileName, trImpInfo, trFilter) )			
//		///---END NO_NEED_LAYER_NUM
//		{
//			//ToDO:error handle
//			ImportErrorMsgBox(IMPERR_IMPORT_FUNC_ERR, NULL); ///---Sim 07-31-2006 ERR_HANDLE
//			return false;			
//		}
//		/// AW 07/31/06 MORE_ON_IW_FILTER
//		GraphLayer lyGraph = GetTargetGraphLayer(trFilter, strGraphPage, bSameFilter );
//		if ( lyGraph )
//		{
//			int nPlotID = fuGetPlotID(trFilter);
//			/// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
//			//if ( nRet = GraphData(lyGraph, nPlotID, lyTarget) )
//			if ( nRet = GraphData(lyGraph, nPlotID, iwFilter.GetDatRange()) )
//			/// END ADD_DATA_RANGE_IN_XF_IMPORT_FILE
//				return nRet;	
//		}
//		/// END MORE_ON_IW_FILTER
//
//	}
//	
//	return true;
//*/
////// END MORE_ON_ADD_IMPFILE_XF
//
//}

BOOL OnDragNDropDataFiles(StringArray& vsDragNDropFileNames, string& strWinName, int iWinLayer, string& strTypes = "")
{
	LPCSTR lpcszTypes = NULL;
	if( !strTypes.IsEmpty() )
	{
		int nC1		= strTypes.Find('(');
		int nC2		= strTypes.Find(')');
		lpcszTypes	= strTypes.Mid( nC1 + 1,nC2 - nC1 - 1);
	}

	DWORD dwCntrl	= strWinName.IsEmpty() ? IMPORT_FILES_DRAG_N_DROP_TO_WORKSPACE : 0;
	return import_files_ex(vsDragNDropFileNames, strWinName, iWinLayer, NULL, lpcszTypes, dwCntrl);
}

typedef BOOL (*PFN_ON_DRAG_N_DROP_FDF)(StringArray& vsDragNDropFileNames, string &strWinName, int iWinLayer);

enum
{
	DRAG_N_DROP_DATA,
	DRAG_N_DROP_FDF,
};

BOOL HandleDragNDropFiles(int nHandleType, string strTypes = "")
{
	static StringArray 	s_vsDragNDropFileNames;

	string strWinName, strFileName;
	int iWinLayer, iFileIndex, iFileCount;

	Project.GetDragDropInfo(strWinName, iWinLayer, iFileIndex, iFileCount, strFileName);

	if ( 0 == iFileIndex )
		s_vsDragNDropFileNames.SetSize(0);
	s_vsDragNDropFileNames.Add(strFileName);

	if ( iFileIndex < iFileCount - 1 )
		return TRUE;

	ASSERT(iFileCount == s_vsDragNDropFileNames.GetSize());

	BOOL bRet					= FALSE;
	switch (nHandleType)
	{
	case DRAG_N_DROP_DATA:
		bRet = OnDragNDropDataFiles(s_vsDragNDropFileNames, strWinName, iWinLayer, strTypes);
		break;
	case DRAG_N_DROP_FDF:
		{
			PFN_ON_DRAG_N_DROP_FDF pfn = (PFN_ON_DRAG_N_DROP_FDF)Project.FindFunction("SelectCategoryDlg", "OriginLab\\SelectCategoryDlg.cpp", true);
			if ( pfn )
			{
				bRet = pfn(s_vsDragNDropFileNames, strWinName, iWinLayer);
			}
		}
		break;
	default:
		ASSERT(FALSE);
		break;
	}

	s_vsDragNDropFileNames.SetSize(0); // clean up after import
	return bRet;
}

BOOL HandleDataFiles(string strTypes)
{
	return HandleDragNDropFiles(DRAG_N_DROP_DATA, strTypes);
}

BOOL HandleDragNDropFDF()
{
	return HandleDragNDropFiles(DRAG_N_DROP_FDF);
}
/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES

/// EJP 2007-05-14 v8.0618 QA70-9634 ADD_FILTERS_WITH_OPTION_TO_FILE_OPEN_DLG
//--------------------------------------------------------------------------
// OpenFileWithFilter
// This function is called from the OpenFile section of File.OGS and is used
// for handling filters that appear in the File Open dialog.
//
// lpcszDataFile = absolute path and name of data file
// lpcszFilterName = filter name, no path nor extension
//--------------------------------------------------------------------------
int OpenFileWithFilter(string lpcszDataFile, string lpcszFilterName)
{
	/// Hong 09/11/07 v8.0700 REMOVE_DUPLICATE_CODE
	/*
	// Import function requires file names to be in a string array.
	// Copy caller's data file to local string array.
	StringArray saDataFiles;
	saDataFiles.Add(lpcszDataFile);

	// Try to load filter from User's Filters folder.
	Tree trFilter;
	string strPath = GetAppPath(FALSE) + lpcszFilterName + ".oif";
	if( !fuLoad(trFilter, lpcszFilterName) )
	{
		// Try to load filter from Origin's Filters folder.
		strPath = GetAppPath(TRUE) + lpcszFilterName + ".oif";
		if( !fuLoad(trFilter, lpcszFilterName) )
			return 1;
	}

	// Import the data file.
	if( !ImportFiles(saDataFiles, NULL, 0, trFilter) )
		return 1;

	return 0;
	*/
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	//return ImportFile(NULL, 0, lpcszDataFile, lpcszFilterName);
	return import_file_ex(NULL, 0, lpcszDataFile, lpcszFilterName);
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	/// end REMOVE_DUPLICATE_CODE
}
/// end ADD_FILTERS_WITH_OPTION_TO_FILE_OPEN_DLG

///---Sim 05-30-2007 PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC
///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
//BOOL ImportFile(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName)
BOOL import_file_ex(LPCSTR strPageName, int nIndexLayer, LPCSTR lpcszDataFile, LPCSTR lpcszFilterName)
///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
{
	///---Sim 01-22-2010 QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	FUNC_IMPORTFILE fImportFile;
	fImportFile = Project.FindFunction(IMPORT_FUNC_NAME_IMPORT_FILE, IMPORT_FUNC_PATH, true);
	ASSERT(fImportFile);	
	///---END QA81-15010 FIX_IMPORT_FILES_FUNCTION_FAILED_TO_RUN_IN_81
	
	// Import function requires file names to be in a string array.
	// Copy caller's data file to local string array.
	StringArray saDataFiles;
	saDataFiles.Add(lpcszDataFile);

	// Try to load filter from User's Filters folder.
	string strFilterName = lpcszFilterName;
	
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	Tree trFilter;
	if ( !strFilterName.IsEmpty() )
	{
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		//Sim, clear code to centralization
#ifndef CLEAR_IMPORT_CODE_81
		string strFilepath = strFilterName;
		string strFname, strFext, strExt;	
		if( !separate_file_name_ext(strFilepath, strFname, strFext) || 0 != strFext.CompareNoCase("oif") )
		{
			strFilterName = strFname + ".oif";
		}
#else
		add_file_extension(strFilterName, IMPORT_FILTER_EXTENSION);
#endif // CLEAR_IMPORT_CODE_81
		//Sim, end of clear code
		
		//Tree trFilter; ///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE remove
		if ( !(GetFilePath(strFilterName).IsEmpty()) )
		{
			if( !fuLoad(trFilter, strFilterName) )
				return false;
		}
		else
		{
			// Try to load filter from Data folder.
			string strPath = GetFilePath(lpcszDataFile) + strFilterName; // load data file folder
			if( !fuLoad(trFilter, strPath) ) 
			{
				/*
				// Try to load filter from Origin's User Filters folder.
				string strPath = GetAppPath(FALSE) + FILTERS_FOLDER_NAME + strFilterName; // load user folder
				if( !fuLoad(trFilter, strPath) ) 
				{
					// Try to load filter from Origin's Filters folder.
					strPath = GetAppPath(TRUE) + FILTERS_FOLDER_NAME + strFilterName; // load system folder
					if( !fuLoad(trFilter, strPath) ) 
						return false;
				}
				*/
				
				// Try to load filter from Origin's Filters folder.
				if( !fuLoad(trFilter, strFilterName) ) 
					return false;
			}
			
		}
	} ///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		
	// Import the data file.
	///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	//if( !ImportFiles(saDataFiles, strPageName, nIndexLayer, trFilter) )
	if( !import_files_ex(saDataFiles, strPageName, nIndexLayer, trFilter) )
	///---END QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
		return false;

	return true;
}
///---End PROVIDE_SOLUTION_FOR_IMPORT_FILE_FROM_80_OC
